import React, {Component, useEffect, useState} from 'react';
import {
  View,
  Text,
  TextInput,
  StyleSheet,
  TouchableOpacity,
  Platform,
  Alert,
} from 'react-native';
import HeaderBack from '../../components/Header/HeaderBack';

import {
  CodeField,
  Cursor,
  useBlurOnFulfill,
  useClearByFocusCell,
} from 'react-native-confirmation-code-field';
import {getFontXD, HEIGHTXD, WIDTHXD} from '../../Config/Functions';
import R from '../../assets/R';
import {NEWPASSWORD} from '../../routers/ScreenNames';
import {verifyOTPApi} from '../../apis/Functions/users';
import {useNavigation} from '@react-navigation/native';

import {showLoading, hideLoading} from '../../actions/loadingAction';
import {connect} from 'react-redux';

const CELL_COUNT = 4;

const ConfirmOTP = (propsa) => {
  const [value, setValue] = useState('');

  const navigate = useNavigation();

  const ref = useBlurOnFulfill({value, cellCount: CELL_COUNT});
  const [props, getCellOnLayoutHandler] = useClearByFocusCell({
    value,
    setValue,
  });

  const confirm = async () => {
    if (!value) {
      Alert.alert('Thông báo', 'Vui long nhập mã OTP');
    } else if (value.length != 4) {
      Alert.alert('Thông báo', 'Mã OTP không đúng định dạng');
    } else {
      propsa.showLoading();
      const res = await verifyOTPApi({
        platform: Platform.OS,
        receiver_name: propsa.route.params.email,
        otp: value,
      });

      propsa.hideLoading();

      if (res.data.code == 200) {
        navigate.navigate(NEWPASSWORD, {
          otp: value,
          email: propsa.route.params.email,
        });
      } else {
        Alert.alert('Thông báo', res.data.message);
      }
    }
  };

  return (
    <View style={{flex: 1}}>
      <HeaderBack title={'Xác thực OTP'} />

      <View style={styles.container}>
        <View style={{height: 20}} />

        <View style={styles.wrap}>
          <Text style={styles.txtTitle}>Mã xác thực:</Text>
          <View style={styles.containerCode}>
            <CodeField
              ref={ref}
              {...props}
              value={value}
              onChangeText={setValue}
              cellCount={CELL_COUNT}
              rootStyle={styles.codeFieldRoot}
              keyboardType="number-pad"
              textContentType="oneTimeCode"
              renderCell={({index, symbol, isFocused}) => (
                <View
                  onLayout={getCellOnLayoutHandler(index)}
                  key={index}
                  style={[styles.cellRoot, isFocused && styles.focusCell]}>
                  <Text style={styles.cellText}>
                    {symbol || (isFocused ? <Cursor /> : null)}
                  </Text>
                </View>
              )}
            />
          </View>
        </View>
      </View>
      <View style={styles.footer}>
        <TouchableOpacity onPress={confirm} style={styles.btn}>
          <Text style={styles.txtBtn}>Tiếp tục</Text>
        </TouchableOpacity>
        <TouchableOpacity
          style={styles.wrapFooter}
          onPress={() => console.log('Hello')}>
          <Text style={styles.txtNote}>Mã OTP có hiệu lực trong 5 phút.</Text>
          <Text style={styles.txtSend}>Gửi lại</Text>
        </TouchableOpacity>
      </View>
    </View>
  );
};

const styles = StyleSheet.create({
  container: {
    flex: 1,
    justifyContent: 'center',
    alignItems: 'center',

    paddingVertical: 20,
  },
  footer: {
    height: 200,
    justifyContent: 'center',
    alignItems: 'center',
  },
  wrap: {
    flex: 1,
    paddingTop: 30,
    alignItems: 'center',
    width: '100%',
    paddingHorizontal: 50,
  },
  containerCode: {
    height: 50,

    width: '100%',
    marginTop: 30,
  },
  codeFieldRoot: {
    marginTop: 20,
  },

  focusCell: {
    borderColor: '#000',
  },
  cellRoot: {
    width: 40,
    height: 40,
    justifyContent: 'center',
    alignItems: 'center',
    borderBottomColor: '#ccc',
    borderBottomWidth: 1,
  },
  cellText: {
    color: '#000',
    fontSize: 36,
    textAlign: 'center',
  },
  focusCell: {
    borderBottomColor: '#007AFF',
    borderBottomWidth: 2,
  },
  txtTitle: {
    fontSize: getFontXD(52),
    color: '#979797',
  },
  btn: {
    width: WIDTHXD(521),
    height: HEIGHTXD(120),
    borderRadius: 15,
    backgroundColor: '#1C6AF6',
    justifyContent: 'center',
    alignItems: 'center',
  },
  txtBtn: {
    color: R.colors.white,
    fontSize: getFontXD(52),
    textTransform: 'uppercase',
  },
  txtSend: {
    fontSize: getFontXD(42),
    color: '#1C6AF6',
  },
  wrapFooter: {
    marginTop: 30,
    flexDirection: 'row',
    alignItems: 'center',
  },
  txtNote: {
    color: '#A2A2A2',
    fontSize: getFontXD(42),
    fontStyle: 'italic',
  },
});

const mapStateToProps = (state) => {
  return {};
};

export default connect(mapStateToProps, {showLoading, hideLoading})(ConfirmOTP);
