import React, {useState} from 'react';
import {
  View,
  Text,
  TextInput,
  StyleSheet,
  TouchableOpacity,
  Platform,
  Alert,
} from 'react-native';
import HeaderBack from '../../components/Header/HeaderBack';
import {connect} from 'react-redux';
import {getFontXD, HEIGHTXD, WIDTHXD} from '../../Config/Functions';
import R from '../../assets/R';
import {useNavigation} from '@react-navigation/native';
import {CONFIRMOTP} from '../../routers/ScreenNames';
import {getOTPApi} from '../../apis/Functions/users';
import {showLoading, hideLoading} from '../../actions/loadingAction';

const ConfirmEmail = (props) => {
  const [value, setValue] = useState('');

  const navigate = useNavigation();

  const getOTP = async () => {
    if (value) {
      props.showLoading();
      const res = await getOTPApi({
        platform: Platform.OS,
        otp_by: value,
      });
      console.log(res.data);
      props.hideLoading();
      if (res.data.code == 200) {
        navigate.navigate(CONFIRMOTP, {email: value});
      } else {
        setTimeout(() => {
          Alert.alert('Thông báo', res.data.message);
        }, 500);
      }
    } else {
      Alert.alert('Thông báo', 'Vui lòng nhập email!');
    }
  };

  return (
    <View style={{flex: 1}}>
      <HeaderBack title={'Quên mật khẩu'} />
      <View style={styles.container}>
        <View style={styles.wrap}>
          <View style={styles.containerCode}>
            <Text style={styles.txtTitle}>Vui lòng nhập email:</Text>
            <TextInput
              placeholderTextColor={R.colors.placeHolder}
              style={styles.txtInput}
              autoCapitalize="none"
              placeholder="Nhập email"
              value={value}
              onChangeText={(val) => setValue(val)}
            />
          </View>
        </View>
      </View>

      <View style={styles.footer}>
        <TouchableOpacity onPress={getOTP} style={styles.btn}>
          <Text style={styles.txtBtn}>Lấy mã xác thực</Text>
        </TouchableOpacity>
        <TouchableOpacity onPress={() => navigate.goBack()}>
          <Text style={styles.txtSend}>Quay lại đăng nhập</Text>
        </TouchableOpacity>
      </View>
    </View>
  );
};

const styles = StyleSheet.create({
  container: {
    flex: 1,
    justifyContent: 'center',
    alignItems: 'center',
    paddingVertical: 20,
  },
  footer: {
    height: 200,
    justifyContent: 'center',
    alignItems: 'center',
  },
  wrap: {
    flex: 1,
    paddingTop: 10,
    alignItems: 'center',
    width: '100%',
    paddingHorizontal: 50,
  },
  containerCode: {
    height: 50,
    width: '100%',
    marginTop: 10,
  },
  codeFieldRoot: {
    marginTop: 20,
  },
  txtTitle: {
    fontSize: getFontXD(48),
    color: '#141414',
    marginBottom: 12,
  },
  txtInput: {
    height: HEIGHTXD(99),

    borderBottomWidth: 2,
    borderBottomColor: '#DBEBFF',
    fontSize: getFontXD(46),

    paddingVertical: 2,

    color: 'black',
  },
  btn: {
    width: WIDTHXD(550),
    height: HEIGHTXD(120),
    borderRadius: 22,
    backgroundColor: '#1C6AF6',
    justifyContent: 'center',
    alignItems: 'center',
  },
  txtBtn: {
    color: R.colors.white,
    fontSize: getFontXD(46),
    textTransform: 'uppercase',
    paddingHorizontal: 10,
  },
  txtSend: {
    marginTop: 30,
    fontSize: getFontXD(42),
    color: '#1C6AF6',
  },
});

const mapStateToProps = (state) => {
  return {};
};

export default connect(mapStateToProps, {showLoading, hideLoading})(
  ConfirmEmail,
);
