import React from 'react';
import {
  View,
  Text,
  KeyboardAvoidingView,
  Platform,
  SafeAreaView,
  StatusBar,
} from 'react-native';
import HeaderAuthen from '../../components/Header/HeaderAuthen';
import {createMaterialTopTabNavigator} from '@react-navigation/material-top-tabs';
import {getFontXD} from '../../Config/Functions';
import Login from './Login';
import Registor from './Registor';
import {ScrollView} from 'react-native-gesture-handler';

const Tab = createMaterialTopTabNavigator();
const Authen = (props) => {
  return (
    <KeyboardAvoidingView
      behavior={Platform.Os === 'ios' ? 'padding' : 'height'}
      style={{flex: 1, backgroundColor: 'white'}}
      keyboardVerticalOffset={-50}>
      <ScrollView showsVerticalScrollIndicator={false}>
        <View style={{flex: 1}}>
          <HeaderAuthen />
          <View style={{flex: 1, backgroundColor: 'white'}}>
            <Tab.Navigator
              initialRouteName="Login"
              tabBarOptions={{
                activeTintColor: '#0045C8',
                labelStyle: {fontSize: getFontXD(42), fontWeight: '700'},
                style: {
                  justifyContent: 'center',
                  marginHorizontal: 40,
                  elevation: 0,
                },
              }}>
              <Tab.Screen
                name="LOGIN"
                component={Login}
                options={{tabBarLabel: 'Đăng nhập'}}
              />
              <Tab.Screen
                name="REGISTOR"
                component={Registor}
                options={{tabBarLabel: 'Đăng ký'}}
              />
            </Tab.Navigator>
          </View>
        </View>
      </ScrollView>
    </KeyboardAvoidingView>
  );
};

export default Authen;
