import React, {useState} from 'react';
import {View, Text, StyleSheet, Dimensions} from 'react-native';
import R from '../../../assets/R';
import HeaderBack from '../../../components/Header/HeaderBack';
import TextField from '../../../components/Input/TextField';
import TextMulti from '../../../components/Input/TextMulti';
import TextDisable from '../../../components/Input/TextDisable';
import {getFontXD, HEIGHTXD, toPriceVnd} from '../../../Config/Functions';
import PickerItem from '../../../components/Picker/PickerItem';
import RadioForm, {
  RadioButton,
  RadioButtonInput,
  RadioButtonLabel,
} from 'react-native-simple-radio-button';

var radio_props = [
  {label: 'Từ ví', value: 0},
  {label: 'Từ tài khoản CQG', value: 1},
];
const {width} = Dimensions.get('window');

const dataType = [
  {
    value: '1',
    name: 'Chứng minh nhân dân',
  },
  {
    value: '2',
    name: 'Hộ chiếu',
  },
  {
    value: '3',
    name: 'Căn cước công dân',
  },
];

const WalletDeposit = (props) => {
  const [account, setAccount] = useState();
  const [type, setType] = useState();
  return (
    <View style={{flex: 1}}>
      <HeaderBack title={'Nạp tiền đầu tư'} />
      <View style={styles.container}>
        <View style={styles.wrapTop}>
          <View style={styles.itemTop}>
            <Text style={styles.txtTitle}>Ví</Text>
            <Text style={styles.txtMoney}>{toPriceVnd(1000000)}</Text>
          </View>
          <View style={{width: 1, backgroundColor: '#DBDBDB'}} />

          <View style={styles.itemTop}>
            <Text style={styles.txtTitle}>CQG</Text>
            <Text style={styles.txtMoney}>{toPriceVnd(1000000)}</Text>
          </View>
        </View>
        <View style={styles.wrapBody}>
          <Text
            style={{
              fontSize: getFontXD(42),
              color: R.colors.color777,
            }}>
            Tài khoản nguồn
          </Text>
          {/* <View style={styles.row}> */}
          <RadioForm
            radio_props={radio_props}
            labelStyle={{fontSize: getFontXD(42)}}
            formHorizontal={true}
            style={styles.row}
            initial={0}
            onPress={(value) => {
              setAccount({value: value});
            }}
          />
          {/* </View> */}
          <Text
            style={{
              fontSize: getFontXD(42),
              color: R.colors.color777,
            }}>
            Chọn tài khoản hưởng thụ
          </Text>
          <PickerItem
            width={width - 20}
            data={dataType}
            onValueChange={(value, items) => {
              setType(items);
            }}
          />

          <TextField title={'Số tiền'} isNumber={true} />
          <TextMulti title={'Ghi chú'} />
        </View>
      </View>
      <View style={styles.btnSend}>
        <Text style={styles.txtSend}>Rút tiền</Text>
      </View>
    </View>
  );
};

const styles = StyleSheet.create({
  container: {
    backgroundColor: R.colors.white,
    marginVertical: 10,
    shadowColor: '#AFA9A9',
    shadowOffset: {
      width: 0,
      height: 1,
    },
    shadowOpacity: 0.25,
    shadowRadius: 1.84,
    elevation: 1,
  },
  wrapTop: {
    flexDirection: 'row',
    borderBottomWidth: 1,
    borderBottomColor: '#DBDBDB',
  },
  itemTop: {
    flex: 1,
    justifyContent: 'center',
    alignItems: 'center',
    paddingVertical: 20,
  },
  wrapBody: {
    paddingHorizontal: 10,
    paddingVertical: 20,
  },
  txtMoney: {
    color: '#1C6AF6',
    fontSize: getFontXD(52),
  },
  txtTitle: {
    color: R.colors.black,
    fontSize: getFontXD(42),
  },
  txtSend: {
    fontSize: getFontXD(42),
    color: R.colors.white,
    fontWeight: 'bold',
  },
  btnSend: {
    position: 'absolute',
    bottom: 30,
    right: width / 2 - 70,
    width: 140,
    height: 40,
    backgroundColor: R.colors.main,
    borderRadius: 10,
    justifyContent: 'center',
    alignItems: 'center',
  },
  row: {
    height: HEIGHTXD(109),
    width: '100%',
    justifyContent: 'space-between',
    marginVertical: 5,
  },
});

export default WalletDeposit;
