import React from 'react';
import {View, Text, StyleSheet, TouchableOpacity, Image} from 'react-native';
import {
  getFontXD,
  HEIGHTXD,
  WIDTHXD,
  toPriceVnd,
} from '../../../Config/Functions';
import R from '../../../assets/R';
import Block from '../../../components/Block';
import {useNavigation} from '@react-navigation/native';
import {DETAIL_REQUIRE_MONEY} from '../../../routers/ScreenNames';

const Item = (props) => {
  const {item} = props;
  //   console.log('item---', item.status);
  const navigate = useNavigation();
  return (
    <TouchableOpacity onPress={() => console.log('HEllo')}>
      <View style={styles.container}>
        <Block flex={1} row>
          <View style={styles.wrapLeft} />
          <View style={styles.wrapDate}>
            {item.status == 1 ? (
              <Image source={R.images.iconRecharge} style={styles.imgIcon} />
            ) : (
              <Image source={R.images.iconWithdrawal} style={styles.imgIcon} />
            )}
          </View>
          <Block
            style={{justifyContent: 'center'}}
            padding={[5, 10]}
            space={'between'}
            flex={1}>
            <View
              style={{
                flexDirection: 'row',
                justifyContent: 'space-between',
              }}>
              <View
                style={{
                  alignItems: 'flex-start',
                }}>
                <Text style={styles.txtBlack}>{item.content}</Text>
                <Text style={styles.txt}>{item.date}</Text>
              </View>

              <View style={{alignItems: 'flex-end'}}>
                {item.status == 1 ? (
                  <Text
                    style={{
                      fontSize: getFontXD(42),
                      fontWeight: 'bold',
                      color: '#F99D1D',
                    }}>
                    {toPriceVnd(item.money)} Đ
                  </Text>
                ) : (
                  <Text
                    style={{
                      fontSize: getFontXD(42),
                      fontWeight: 'bold',
                      color: '#1473E6',
                    }}>
                    {toPriceVnd(item.money)} Đ
                  </Text>
                )}
                <Text style={styles.txt}>Hoàn tất</Text>
              </View>
            </View>
          </Block>
        </Block>
      </View>
    </TouchableOpacity>
  );
};

export default Item;

const styles = StyleSheet.create({
  container: {
    height: HEIGHTXD(250),
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 2,
    },
    shadowOpacity: 0.25,
    shadowRadius: 3.84,
    elevation: 5,
    marginHorizontal: 10,
    backgroundColor: R.colors.white,
    marginTop: 10,
    borderRadius: HEIGHTXD(30),
  },
  wrapRight: {
    borderLeftColor: R.colors.borderGray,
    borderLeftWidth: 0.7,
  },
  wrapLeft: {
    width: WIDTHXD(16),
    borderTopLeftRadius: HEIGHTXD(30),
    borderBottomStartRadius: HEIGHTXD(30),
  },
  wrapDate: {
    justifyContent: 'center',
    paddingHorizontal: 10,
  },
  txt: {
    fontSize: getFontXD(36),
    color: '#C4C4C4',
  },
  imgIcon: {
    width: WIDTHXD(178),
    height: HEIGHTXD(178),
    resizeMode: 'contain',
  },
});
