import React, {useState} from 'react';
import {View, Text, FlatList, TouchableOpacity, StyleSheet} from 'react-native';
import HeaderSB from '../../../components/Header/HeaderSB';
import Item from './Item';
import {getFontXD} from '../../../Config/Functions';
const Fillters = [
  {
    id: '1',
    name: 'Tất cả',
    value: 'all',
  },

  {
    id: '4',
    name: 'Rút tiền',
    value: 'withdraw',
  },
  {
    id: '5',
    name: 'Nạp tiền',
    value: 'deposit',
  },
  {
    id: '6',
    name: 'Chuyển khoản',
    value: 'exchange',
  },
];

const data = [
  {
    id: '1',
    money: 10000000,
    content: 'Hoạt động: Nạp tiền',
    status: 1,
    date: '20/02/2021',
  },
  {
    id: '2',
    money: 2000000,
    content: 'Hoạt động: Nạp tiền',
    status: 1,
    date: '20/02/2021',
  },
  {
    id: '3',
    day: '20',
    money: 3000000,
    content: 'Hoạt động: Nạp tiền',
    status: 1,
    date: '20/02/2021',
  },
  {
    id: '4',
    money: 4000000,
    content: 'Hoạt động: Rút tiền',
    status: 2,
    date: '20/02/2021',
  },
  {
    id: '5',
    money: 9000000,
    content: 'Hoạt động: Nạp tiền',
    status: 1,
    date: '20/02/2021',
  },
];

const HistoryView = (props) => {
  const [selected, setSelected] = useState('1');
  return (
    <View style={{flex: 1}}>
      <HeaderSB title={'LỊCH SỬ'} />
      <View style={{flex: 1}}>
        <View style={styles.headerContainer}>
          <FlatList
            showsHorizontalScrollIndicator={false}
            horizontal
            data={Fillters}
            keyExtractor={(item) => item.id}
            renderItem={({item}) => (
              <TouchableOpacity
                onPress={() => setSelected(item.id)}
                style={[
                  styles.itemFillter,
                  selected == item.id ? {borderColor: '#1473E6'} : null,
                ]}>
                <Text
                  style={[
                    styles.txtFillter,
                    selected == item.id ? {color: '#1473E6'} : {},
                  ]}>
                  {item.name}
                </Text>
              </TouchableOpacity>
            )}
          />
        </View>
        <FlatList
          keyExtractor={(item) => item.id}
          data={data}
          renderItem={({item}) => <Item item={item} />}
        />
      </View>
    </View>
  );
};

const styles = StyleSheet.create({
  headerContainer: {
    paddingVertical: 10,
    backgroundColor: 'white',
  },
  itemFillter: {
    borderRadius: 10,
    paddingVertical: 5,
    paddingHorizontal: 10,
    borderWidth: 1,
    borderColor: '#929292',
    marginLeft: 15,
    minWidth: 70,
  },
  txtFillter: {
    fontSize: getFontXD(36),
    color: '#929292',
  },
});

export default HistoryView;
