import React, {useState} from 'react';
import {
  View,
  Text,
  TouchableOpacity,
  Image,
  StyleSheet,
  Alert,
  KeyboardAvoidingView,
  ScrollView,
  Platform,
  Dimensions,
} from 'react-native';
import PickerImgUni from '../../../components/Picker/PickerImgUni';
import R from '../../../assets/R';
import TextField from '../../../components/Input/TextField';
import {
  checkFormatArray,
  getFontXD,
  convertTime,
} from '../../../Config/Functions';
import PickerDate from '../../../components/Picker/PickerDate';
import PickerItem from '../../../components/Picker/PickerItem';
const {width} = Dimensions.get('window');

const dataType = [
  {
    value: '1',
    name: 'Chứng minh nhân dân',
  },
  {
    value: '2',
    name: 'Hộ chiếu',
  },
  {
    value: '3',
    name: 'Căn cước công dân',
  },
];

const Profile = (props) => {
  const [urlFont, setUrlFont] = useState('');
  const [urlBack, setUrlBack] = useState('');
  const [urlSign, setUrlSign] = useState('');
  const [cmnd, setCMND] = useState('');
  const [date_range, setDate_range] = useState(new Date());
  const [type, setType] = useState();

  const onNextPress = () => {
    const titles = [
      'loại thẻ',
      'số thẻ',
      'ảnh CNND mặt trước',
      'ảnh CMND mặt sau',
      'ảnh chữ ký',
    ];
    const index = checkFormatArray([type, cmnd, urlFont, urlBack, urlSign]);

    if (index === true) {
      props.navigation.navigate('BankInfor', {
        body: {
          cmnd,
          card_type: type.value,
          date_range: convertTime(date_range),
          ...props.route.params,
        },
        img: {
          urlFont,
          urlBack,
          urlSign,
        },
      });
    } else {
      Alert.alert('Vui lòng thêm ' + titles[index]);
    }
  };

  return (
    <KeyboardAvoidingView
      behavior={Platform.Os === 'ios' ? 'padding' : 'height'}
      style={{flex: 1}}
      keyboardVerticalOffset={-50}>
      <ScrollView showsVerticalScrollIndicator={false}>
        <View
          style={{
            flex: 1,
            paddingHorizontal: 10,
            paddingTop: 10,
          }}>
          <Text
            style={{
              fontSize: getFontXD(42),
              color: R.colors.color777,
            }}>
            Loại thẻ
          </Text>
          <PickerItem
            width={width - 20}
            data={dataType}
            onValueChange={(value, items) => {
              setType(items);
            }}
          />

          <TextField
            isNumber={true}
            title={'Số thẻ'}
            onChangeText={(val) => setCMND(val)}
          />
          <PickerDate
            value={date_range}
            onValueChange={(val) => setDate_range(val)}
            title={'Ngày cấp'}
          />
          <View
            style={{
              flexDirection: 'row',
              justifyContent: 'space-between',
              flexWrap: 'wrap',
            }}>
            <PickerImgUni
              onSelectImg={(path) => setUrlFont(path)}
              title={'Ảnh mặt trước CMND'}
            />
            <PickerImgUni
              onSelectImg={(path) => setUrlBack(path)}
              title={'Ảnh mặt sau CMND'}
            />
            <PickerImgUni
              onSelectImg={(path) => setUrlSign(path)}
              title={'Ảnh chữ ký'}
            />
          </View>
          <TouchableOpacity onPress={onNextPress} style={styles.btnNext}>
            <Image
              style={{width: 30, height: 30}}
              source={R.images.iconRight1}
            />
          </TouchableOpacity>
        </View>
      </ScrollView>
    </KeyboardAvoidingView>
  );
};

const styles = StyleSheet.create({
  btnNext: {
    borderRadius: 30,
    backgroundColor: '#1473E6',
    width: 50,
    height: 50,
    justifyContent: 'center',
    alignItems: 'center',
    marginTop: 20,
    alignSelf: 'flex-end',
    elevation: 2,
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 1,
    },
    shadowOpacity: 0.15,
    shadowRadius: 1.84,
  },
});

export default Profile;
