import React, {useState} from 'react';
import {
  View,
  Text,
  Image,
  TouchableOpacity,
  StyleSheet,
  Alert,
  KeyboardAvoidingView,
  ScrollView,
  Platform,
} from 'react-native';
import R from '../../../assets/R';

import TextField from '../../../components/Input/TextField';
import TextMulti from '../../../components/Input/TextMulti';
import PickerDate from '../../../components/Picker/PickerDate';
import PickerImg from '../../../components/Picker/PickerImg';

import {checkFormatArray, convertTime} from '../../../Config/Functions';

const GeneralInfor = (props) => {
  const [lastName, setLastName] = useState('');
  const [firstName, setFirstName] = useState('');
  const [email, setEmail] = useState('');

  const [phone, setPhone] = useState('');
  const [address, setAdress] = useState('');
  const [birth, setBirth] = useState(new Date());

  const onNextPress = () => {
    const titles = ['tên', 'họ', 'số điện thoại', 'địa chỉ'];
    const index = checkFormatArray([lastName, firstName, phone, address]);

    if (index === true) {
      props.navigation.navigate('Profile', {
        l_name: lastName,
        f_name: firstName,
        mobile: phone,
        birthday: convertTime(birth),
        address,
        email,
      });
    } else {
      Alert.alert('Vui lòng điền ' + titles[index]);
    }
  };

  return (
    <KeyboardAvoidingView
      behavior={Platform.Os === 'ios' ? 'padding' : 'height'}
      style={{flex: 1}}
      keyboardVerticalOffset={-50}>
      <ScrollView showsVerticalScrollIndicator={false}>
        <View style={{flex: 1, paddingHorizontal: 10, paddingTop: 10}}>
          <TextField title={'Email'} onChangeText={(val) => setEmail(val)} />
          <View style={{flexDirection: 'row'}}>
            <View style={{flex: 1}}>
              <TextField
                title={'Họ và tên đệm'}
                onChangeText={(val) => setLastName(val)}
              />
            </View>
            <View style={{width: 20}} />
            <View style={{flex: 1}}>
              <TextField
                title={'Tên'}
                onChangeText={(val) => setFirstName(val)}
              />
            </View>
          </View>
          <TextField
            isNumber={true}
            title={'Số điện thoại'}
            onChangeText={(val) => setPhone(val)}
          />
          <PickerDate
            value={birth}
            onValueChange={(val) => setBirth(val)}
            title={'Ngày sinh'}
          />

          <TextMulti title={'Địa chỉ'} onChangeText={(val) => setAdress(val)} />
          <TouchableOpacity onPress={onNextPress} style={styles.btnNext}>
            <Image
              style={{width: 30, height: 30}}
              source={R.images.iconRight1}
            />
          </TouchableOpacity>
          <View style={{height: 100}} />
        </View>
      </ScrollView>
    </KeyboardAvoidingView>
  );
};

const styles = StyleSheet.create({
  btnNext: {
    borderRadius: 30,
    backgroundColor: '#1473E6',
    width: 50,
    height: 50,
    justifyContent: 'center',
    alignItems: 'center',
    marginTop: 20,
    alignSelf: 'flex-end',
    elevation: 2,
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 1,
    },
    shadowOpacity: 0.15,
    shadowRadius: 1.84,
  },
});

export default GeneralInfor;
