import React, {useState} from 'react';
import {
  View,
  Text,
  KeyboardAvoidingView,
  ScrollView,
  Platform,
} from 'react-native';
import HeaderBack from '../../components/Header/HeaderBack';
import BankInfor from './Tab/BankInfor';
import GeneralInfor from './Tab/GeneralInfor';
import Profile from './Tab/Profile';
import {createMaterialTopTabNavigator} from '@react-navigation/material-top-tabs';
import {getFontXD} from '../../Config/Functions';
const Tab = createMaterialTopTabNavigator();

const AccountVerificationView = (props) => {
  return (
    <View style={{flex: 1}}>
      <HeaderBack isWhite={true} title={'Xác minh tài khoản'} />
      <Tab.Navigator
        initialRouteName="GeneralInfor"
        tabBarOptions={{
          inactiveTintColor: '#929292',
          activeTintColor: '#1473E6',
          labelStyle: {fontSize: getFontXD(36)},
          style: {backgroundColor: 'white'},
          scrollEnabled: true,
        }}>
        <Tab.Screen
          name="GeneralInfor"
          component={GeneralInfor}
          options={{tabBarLabel: 'Thông tin chung'}}
        />
        <Tab.Screen
          name="Profile"
          component={Profile}
          options={{tabBarLabel: 'Hồ sơ'}}
        />
        <Tab.Screen
          name="BankInfor"
          component={BankInfor}
          options={{tabBarLabel: 'Ngân hàng'}}
        />
      </Tab.Navigator>
    </View>
  );
};

export default AccountVerificationView;
