import React, {useState} from 'react';
import {View, Text, StyleSheet, ScrollView} from 'react-native';
import HeaderBack from '../../../components/Header/HeaderBack';
import CheckBox from '@react-native-community/checkbox';
import R from '../../../assets/R';
import {getFontXD, toPriceVnd} from '../../../Config/Functions';
import ContainerTop from './ContainerTop';
import WrapNomarl from './WrapNomarl';
import Footer from './Footer';

const data = [
  {
    id: '1',
    title: '',
    list: [
      {title: 'ICR EU3', isDetail: true, price: 3840000},
      {title: 'ICR US', isDetail: true, price: 3840000},
      {title: 'SGX', isDetail: true, price: 3840000},
      {title: 'TOCOM', isDetail: true, price: 3840000},
    ],
  },
  {
    id: '2',
    title: 'Dữ liệu người dùng chuyện nghiệp',
    list: [
      {title: 'ICR EU3', isDetail: true, price: 3840000},
      {title: 'ICR US', isDetail: true, price: 3840000},
      {title: 'SGX', isDetail: true, price: 3840000},
      {title: 'TOCOM', isDetail: true, price: 3840000},
    ],
  },
];

const Item = () => {
  const [isSelected, setSelection] = useState(false);
  return (
    <View style={styles.item}>
      <View style={{flex: 1}}>
        <Text>Mở tài khoản giao dịch CQG</Text>
      </View>
      <View
        style={{
          width: 120,
          marginRight: 30,
          alignItems: 'flex-end',
        }}>
        <Text style={[styles.txtMoney, {color: '#18B918'}]}>Miễn phí</Text>
      </View>
      <CheckBox
        value={isSelected}
        onValueChange={setSelection}
        boxType={'square'}
      />
    </View>
  );
};

const PacketCQG = (props) => {
  const [isSelected, setSelection] = useState(false);
  return (
    <View style={{flex: 1}}>
      <HeaderBack title={'Mở tài khoản CQG'} />
      <ScrollView showsVerticalScrollIndicator={true}>
        <View style={styles.container}>
          <Text style={styles.txtNote}>
            Lưu ý:Phí được tính theo tháng và mức giá này được áp dụngđến hết
            ngày 30/12/2021.
          </Text>
          <ContainerTop />
          <Text style={styles.txtTitle}>Phí kết nối dữ liệu</Text>
          {data.map((e) => (
            <View key={e.id}>
              {e.title ? <Text style={styles.txtGroup}>{e.title}</Text> : null}
              <View style={styles.wrap}>
                {e.list.map((e) => (
                  <Item />
                ))}
              </View>
            </View>
          ))}

          <Text style={styles.txtGroup}>
            Dữ liệu người dùng không chuyên nghệp
          </Text>
          <WrapNomarl />

          <Footer />

          <View style={{height: 20}} />
        </View>
      </ScrollView>
    </View>
  );
};

const styles = StyleSheet.create({
  container: {
    paddingHorizontal: 10,
    paddingTop: 10,
  },
  checkboxContainer: {
    flexDirection: 'row',
    marginBottom: 20,
  },
  checkbox: {
    alignSelf: 'flex-end',
  },
  txtNote: {
    fontStyle: 'italic',
  },
  wrap: {
    marginVertical: 10,
    backgroundColor: R.colors.white,
    paddingVertical: 10,
    paddingHorizontal: 10,
    borderRadius: 10,
    shadowColor: '#AFA9A9',
    shadowOffset: {
      width: 0,
      height: 1,
    },
    shadowOpacity: 0.25,
    shadowRadius: 1.84,
    elevation: 1,
  },
  item: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    alignItems: 'center',
    marginVertical: 10,
  },
  txtMoney: {
    fontSize: getFontXD(42),
    color: '#FFB721',
  },
  txtTitle: {
    fontSize: getFontXD(42),
    color: R.colors.main,
    marginTop: 10,
    fontWeight: 'bold',
  },
  txtGroup: {
    fontSize: getFontXD(42),
    color: R.colors.main,
    fontStyle: 'italic',
  },
});

export default PacketCQG;
