import React, {useEffect} from 'react';
import {View, Text, ImageBackground, StyleSheet, StatusBar} from 'react-native';

import {connect} from 'react-redux';
import StackNavigation from './routers/StackNavigation';
import Modal from 'react-native-modal';
import {SkypeIndicator} from 'react-native-indicators';
import {HEIGHT, HEIGHTXD} from './Config/Functions';
import R from './assets/R';
import FirebaseNotification from './helper/FirebaseNotification';

const RootView = (props) => {
  onReceived = (notification) => {};
  onOpened = (notification) => {
    console.log(('notification', notification));
  };
  return (
    <View style={{flex: 1}}>
      <FirebaseNotification onReceived={onReceived} onOpened={onOpened} />
      <Modal isVisible={props.loadingModal.isVisible}>
        <SkypeIndicator color={'white'} />
      </Modal>
      <StackNavigation />
    </View>
  );
};

const mapStateToProps = (state) => {
  return {
    loadingModal: state.ModalLoadingReducer,
  };
};

export default connect(mapStateToProps, {})(RootView);
