import React from 'react';
import {
  View,
  Text,
  StyleSheet,
  TouchableOpacity,
  Image,
  Alert,
} from 'react-native';
import {
  getFontXD,
  HEIGHTXD,
  WIDTHXD,
  toPriceVnd,
} from '../../../Config/Functions';
import R from '../../../assets/R';
import Block from '../../../components/Block';

const Item = (props) => {
  const {item} = props;
  return (
    <View style={styles.container}>
      <TouchableOpacity onPress={() => props.onPress(item)}>
        <Block flex={1} row>
          <View style={styles.wrapDate}>
            <Image source={R.images.iconRecharge} style={styles.imgIcon} />
          </View>
          <Block padding={[5, 10]} space={'between'} flex={1}>
            <View
              style={{
                flex: 1,
                flexDirection: 'row',
                justifyContent: 'space-between',
              }}>
              <Text numberOfLines={2} style={styles.txtBlack}>
                Ngô CBOT
              </Text>
              <Text style={styles.txtMoney}>Thứ 2-Thứ 6</Text>
            </View>
            <Text style={styles.txt}>Phiên 1: 07:00-19:45</Text>
            <Text style={styles.txt}>Phiên 2: 20:30-01:20</Text>
          </Block>
        </Block>
      </TouchableOpacity>
    </View>
  );
};

export default Item;

const styles = StyleSheet.create({
  container: {
    marginTop: 10,
    paddingVertical: 10,
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 2,
    },
    shadowOpacity: 0.25,
    shadowRadius: 3.84,
    elevation: 5,
    marginHorizontal: 10,
    backgroundColor: R.colors.white,
    marginBottom: 10,
    borderRadius: HEIGHTXD(30),
  },

  wrapLeft: {
    width: WIDTHXD(16),
    borderTopLeftRadius: HEIGHTXD(30),
    borderBottomStartRadius: HEIGHTXD(30),
  },
  wrapDate: {
    justifyContent: 'center',
    paddingLeft: 10,
  },
  txtTitle: {
    fontSize: getFontXD(42),
    color: R.colors.black,
    fontWeight: 'bold',
  },
  txt: {
    fontSize: getFontXD(36),
  },
  rowBet: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    alignItems: 'center',
  },
  txtBlack: {
    fontSize: getFontXD(42),
    color: 'black',
    fontWeight: 'bold',
  },
  imgIcon: {
    width: WIDTHXD(178),
    height: HEIGHTXD(178),
    resizeMode: 'contain',
  },
  txtMoney: {
    fontSize: getFontXD(42),
    color: R.colors.main,
  },
});
