import React, {useState} from 'react';
import {
    View,
    TouchableOpacity,
    Text,
    LayoutAnimation,
    StyleSheet,
} from 'react-native';
import R from '../../../../../../assets/R';

import Ionicons from 'react-native-vector-icons/Ionicons';
import {getFontXD, getLineHeightXD, HEIGHTXD, WIDTHXD} from '../../../../../../Config/Functions';
import I18n from '../../../../../../helper/i18/i18n';

const GeneralInfo = (props) => {
    const [expanded, setExpanded] = useState(true);
    const changeLayout = () => {
        LayoutAnimation.configureNext({
            duration: 500,
            create: {
                type: LayoutAnimation.Types.spring,
                property: LayoutAnimation.Properties.scaleY,
                springDamping: 1.7,
            },
            update: {
                type: LayoutAnimation.Types.spring,
                springDamping: 1.7,
            },
        });
        setExpanded(!expanded);
    };

    return (
        <View style={styles.container}>
            <TouchableOpacity
                onPress={() => changeLayout()}
                style={[styles.flexTitle, {
                    borderBottomWidth: expanded === true ? 0.3 : 0,
                    paddingHorizontal: WIDTHXD(30),
                }]}
            >
                <Text style={styles.title}>{I18n.t('GeneralInformation')}</Text>
                {expanded === true ? (
                    <Ionicons
                        name='chevron-up'
                        size={WIDTHXD(50)}
                        style={{marginRight: WIDTHXD(50)}}
                        color={R.colors.iconGray}
                    />
                ) : (
                    <Ionicons
                        name='chevron-down'
                        size={WIDTHXD(50)}
                        style={{marginRight: WIDTHXD(50)}}
                        color={R.colors.iconGray}
                    />
                )}
            </TouchableOpacity>
            {expanded ?
                <Text style={styles.content}>{`Theo quy định của sản phẩm Đậu tương CBOT giao dịch trên Sở Giao dịch Hàng hóa CBOT. \nĐậu tương được giao dịch là đậu tương loại 1, đậu tương loại 2, đậu tương loại 3 đáp ứng những tiêu chuẩn được mô tả ở bảng dưới:`}</Text>
                : null
            }
        </View>
    );

};
export default GeneralInfo;
const styles = StyleSheet.create({
    container: {
        backgroundColor: R.colors.white,
        width: '100%',
        shadowColor: '#181F4D21',
        shadowOffset: {width: 1, height: 1},
        shadowOpacity: 1,
        shadowRadius: 2,
        elevation: 1,
    },
    flexTitle: {
        flexDirection: 'row',
        alignItems: 'center',
        justifyContent: 'space-between',
        paddingVertical: HEIGHTXD(36),
        borderBottomColor: R.colors.borderGray,
    },
    title: {
        fontSize: getFontXD(36),
        lineHeight: getLineHeightXD(56),
        color: R.colors.main,
        textTransform: 'uppercase',
    },
    content: {
        flex: 3.5,
        fontSize: getFontXD(36),
        color: R.colors.black,
        paddingVertical: HEIGHTXD(30),
        paddingHorizontal: HEIGHTXD(30)
    },
});
