import React, {useState} from 'react';
import {
    View,
    ScrollView,
    StyleSheet,
} from 'react-native';
import R from '../../../../../assets/R';
import GeneralInfo from './ItemView/GeneralInfo';
import TimeTransaction from './ItemView/TimeTransaction';
import PriceInfo from './ItemView/PriceInfo';
import {HEIGHTXD} from '../../../../../Config/Functions';

const ContractDescription = (props) => {
    return (
        <ScrollView
            style={styles.container}
            showsVerticalScrollIndicator={false}>
            <View style={{marginBottom: HEIGHTXD(100)}}>
                <GeneralInfo/>
                <TimeTransaction/>
                <PriceInfo/>
            </View>
        </ScrollView>
    );

};
export default ContractDescription;

const styles = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor: R.colors.colorBackground,
        paddingTop: HEIGHTXD(30),
    },
});
