import React, {useState} from 'react';
import {
  View,
  Text,
  FlatList,
  StyleSheet,
  TouchableOpacity,
  ScrollView,
} from 'react-native';

import HeaderDrawer from '../../../components/Header/HeaderDrawer';
import Item from './Item';
import {getFontXD} from '../../../Config/Functions';
import AppText from '../../../components/AppText';
import {PRODUCTDETAIL} from '../../../routers/ScreenNames';
import {useNavigation} from '@react-navigation/native';

const Fillters = [
  {
    id: '1',
    name: 'All',
    value: 'ALL',
  },
  {
    id: '2',
    name: 'Deposit',
    value: 'DEPOSIT',
  },
  {
    id: '3',
    name: 'Withdraw',
    value: 'WITHDRAW',
  },
  {
    id: '4',
    name: 'Transfer',
    value: 'TRANSFER',
  },
];

const NotificaitonView = (props) => {
  const {onRefresh, isRefresh, onLoadMore, setFillters, fillter, data} = props;
  const navigate = useNavigation();

  return (
    <View style={{flex: 1}}>
      <View style={styles.headerContainer}>
        <ScrollView horizontal showsHorizontalScrollIndicator={false}>
          {Fillters.map((e) => (
            <TouchableOpacity
              key={e.value}
              onPress={() => setFillters(e.value)}
              style={[
                styles.itemFillter,
                fillter == e.value ? {borderColor: '#1473E6'} : null,
              ]}>
              <AppText
                i18nKey={e.name}
                style={[
                  styles.txtFillter,
                  fillter == e.value ? {color: '#1473E6'} : {},
                ]}></AppText>
            </TouchableOpacity>
          ))}
        </ScrollView>
      </View>

      {data.length == 0 ? (
        <View style={{justifyContent: 'center', alignItems: 'center', flex: 1}}>
          <AppText
            i18nKey={'NoData'}
            style={{
              fontSize: 18,
              fontWeight: 'bold',
            }}></AppText>
        </View>
      ) : (
        <FlatList
          keyExtractor={(item) => item.id}
          data={data}
          refreshing={isRefresh}
          onRefresh={onRefresh}
          onEndReachedThreshold={0.01}
          onEndReached={(info) => {
            onLoadMore();
          }}
          renderItem={({item}) => <Item item={item}
                                        onPress={(item) => navigate.navigate(PRODUCTDETAIL)}/>}
        />
      )}
    </View>
  );
};

const styles = StyleSheet.create({
  headerContainer: {
    paddingVertical: 10,
    backgroundColor: 'white',
    flexDirection: 'row',
    alignItems: 'center',
    paddingHorizontal: 10,
  },
  itemFillter: {
    borderRadius: 10,
    paddingVertical: 5,
    paddingHorizontal: 10,
    borderWidth: 1,
    borderColor: '#929292',
    justifyContent: 'center',
    alignItems: 'center',
    marginRight: 10,
  },
  txtFillter: {
    fontSize: getFontXD(36),
    color: '#929292',
    fontWeight: 'bold',
  },
  txtTitle: {
    fontSize: getFontXD(46),
    fontWeight: 'bold',
  },
});

export default NotificaitonView;
