import React, {useState, useEffect} from 'react';
import {getListNotification} from '../../../apis/Functions/users';
import PriceListView from './PriceListView';
import I18n from '../../../helper/i18/i18n';
const PriceList = (props) => {
  const [selected, setSelected] = useState('');
  const [page, setPage] = useState(1);
  const [data, setData] = useState([]);
  const [tottalPage, setTotalPage] = useState(1);
  const [isRefresh, setisRefresh] = useState(false);
  const [fillter, setFillters] = useState('ALL');

  useEffect(() => {
    getData();
  }, [fillter]);

  const getData = async () => {
    setisRefresh(true);
    setPage(1);
    const res = await getListNotification({
      keyword: '',
      platform: Platform.OS,
      page_size: 10,
      page_index: 1,
      type: fillter,
    });
    setisRefresh(false);
    if ((res.data.code = 200 && res.data.data)) {
      setData(res.data.data);
      setTotalPage(res.data.meta.pages);
    } else {
      Alert.alert(I18n.t('Notification'), res.data.message);
    }
  };

  const onRefresh = () => {
    getData();
  };

  const onLoadMore = () => {
    console.log(tottalPage);
    if (page < tottalPage) getDataLoadMore();
  };

  const getDataLoadMore = async () => {
    setisRefresh(true);
    const res = await getListNotification({
      keyword: '',
      platform: Platform.OS,
      page_size: 10,
      page_index: 1,
      type: fillter,
    });
    setPage(page + 1);
    if (res.data.code == 200) {
      setData(data.concat(res.data.data));
    }
    setisRefresh(false);
  };

  return (
    <PriceListView
      onRefresh={onRefresh}
      isRefresh={isRefresh}
      onLoadMore={onLoadMore}
      setFillters={setFillters}
      fillter={fillter}
      data={data}
    />
  );
};

export default PriceList;
