import React from 'react';
import {View, Text, TouchableOpacity, Image, StyleSheet} from 'react-native';
import R from '../../../../assets/R';
import {getFontXD} from '../../../../Config/Functions';
import {connect} from 'react-redux';
import AppText from '../../../../components/AppText';
import I18n from '../../../../helper/i18/i18n';

const Profile = (props) => {
  return (
    <View style={styles.container}>
      {props.user.status == 3 ? (
        <View>
          {' '}
          <View style={styles.item}>
            <AppText i18nKey={'ContactCode'} style={styles.txtTitle}></AppText>
            <Text style={styles.txtBig}>{props.user.cqg_id}</Text>
          </View>
          <View style={styles.item}>
            <AppText
              i18nKey={'TraddingAccountName'}
              style={styles.txtTitle}></AppText>
            <Text style={styles.txtBig}>{props.user.cqg_name}</Text>
          </View>
          <View style={styles.item}>
            <AppText
              i18nKey={'TraddingAccountNumber'}
              style={styles.txtTitle}></AppText>
            <Text style={styles.txtBig}>{props.user.account}</Text>
          </View>
        </View>
      ) : (
        <View>
          <Text>Hello</Text>
        </View>
      )}
    </View>
  );
};

const styles = StyleSheet.create({
  container: {
    flex: 1,

    paddingHorizontal: 10,
  },
  item: {
    paddingBottom: 15,
    borderBottomWidth: 1,
    borderBottomColor: '#DBDBDB',
    marginTop: 10,
  },
  txtTitle: {
    fontSize: getFontXD(42),
    color: R.colors.color777,
    marginBottom: 5,

    paddingTop: 5,
  },
  txtBig: {
    fontSize: getFontXD(46),
  },
});

const mapStateToProps = (state) => {
  return {
    user: state.userReducer,
  };
};
export default connect(mapStateToProps, {})(Profile);
