import React, {useState, useEffect} from 'react';
import {
  View,
  Text,
  StyleSheet,
  ScrollView,
  Image,
  TouchableOpacity,
  Alert,
} from 'react-native';
import HeaderBack from '../../../components/Header/HeaderBack';
import CheckBox from '@react-native-community/checkbox';
import R from '../../../assets/R';
import {getFontXD, toPriceVnd} from '../../../Config/Functions';

const FeePro = (props) => {
  const {title, data} = props.data;

  const [listItem, setListItem] = useState([]);

  useEffect(() => {
    const newList = data.map((e) => {
      return {...e, selected: false, disable: false};
    });

    setListItem(newList);
  }, [props.data]);

  const onSelected = (selected) => {
    if (selected.id == 10) {
      const newList = listItem.map((e) => {
        if (e.type_data != 'MD') return e;
        if (selected.selected == false) {
          const newList = listItem.filter(
            (e) => e.type_data == 'MD' && !e.selected,
          );
          props.onChooseAllMD(newList);
          if (e.id == 10) return {...e, selected: true, disable: false};
          return {...e, selected: true, disable: !e.disable};
        } else {
          props.onRemoveAllMD();
          if (e.id == 10) return {...e, selected: false, disable: false};
          return {...e, selected: false, disable: !e.disable};
        }
      });
      setListItem(newList);
    } else if (selected.id == 11) {
      const newList = listItem.map((e) => {
        if (e.type_data != 'TB') return e;
        else {
          if (selected.selected == false) {
            const newList = listItem.filter(
              (e) => e.type_data == 'TB' && !e.selected,
            );
            props.onChooseAllTB(newList);
            if (e.id == 11) return {...e, selected: true, disable: false};
            return {...e, selected: true, disable: !e.disable};
          } else {
            props.onRemoveAllTB();
            if (e.id == 11) return {...e, selected: false, disable: false};
            return {...e, selected: false, disable: !e.disable};
          }
        }
      });

      setListItem(newList);
    } else {
      const newList = listItem.map((e) => {
        if (e.id != selected.id) return e;
        if (e.selected == false) props.onChoosePacket(e);
        else props.onRemovePacket(e);
        return {...e, selected: !e.selected};
      });
      setListItem(newList);
    }
  };

  return (
    <View>
      <Text style={styles.txtTitle}> {title}</Text>
      <View style={styles.wrap}>
        {listItem.map((e) => (
          <View key={e.id + 'a'} style={styles.item}>
            <TouchableOpacity
              onPress={() => Alert.alert(e.note)}
              style={{flex: 1, flexDirection: 'row'}}>
              <Text>
                {' '}
                {e.name}+{e.type_data}
              </Text>
              {e.note ? (
                <View style={{marginLeft: 5}}>
                  <Image
                    style={{width: 20, height: 20}}
                    source={R.images.iconNote}
                  />
                </View>
              ) : null}
            </TouchableOpacity>
            <View
              style={{
                width: 120,
                marginRight: 30,
                alignItems: 'flex-end',
              }}>
              <Text style={styles.txtMoney}>
                {toPriceVnd(e.price_package.price)}
              </Text>
            </View>
            <CheckBox
              disabled={e.disable}
              value={e.selected}
              onValueChange={() => onSelected(e)}
              boxType={'square'}
            />
          </View>
        ))}
      </View>
    </View>
  );
};

const styles = StyleSheet.create({
  container: {
    paddingHorizontal: 10,
    paddingTop: 10,
  },
  checkboxContainer: {
    flexDirection: 'row',
    marginBottom: 20,
  },

  checkbox: {
    alignSelf: 'flex-end',
  },
  txtNote: {
    fontStyle: 'italic',
  },
  wrap: {
    marginVertical: 10,
    backgroundColor: R.colors.white,
    paddingVertical: 10,
    borderRadius: 10,
    shadowColor: '#AFA9A9',
    shadowOffset: {
      width: 0,
      height: 1,
    },
    shadowOpacity: 0.25,
    shadowRadius: 1.84,
    elevation: 1,
  },
  item: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    paddingHorizontal: 10,
    marginVertical: 10,
  },
  txtMoney: {
    fontSize: getFontXD(42),
    color: '#FFB721',
  },
  txtTitle: {
    fontSize: getFontXD(42),
    color: R.colors.main,
    marginTop: 10,
  },
  txtGroup: {
    fontSize: getFontXD(42),
    color: R.colors.main,

    fontStyle: 'italic',
  },
});

export default FeePro;
