import React, {Component, useEffect, useState} from 'react';
import {View, Text, Platform, Alert} from 'react-native';
import I18n from '../../../helper/i18/i18n';

import MediaView from './MediaView';
import {getListMedia} from '../../../apis/Functions/NewFeed';

const Media = (props) => {
  const [data, setData] = useState([]);
  const [mediaHot, setMediaHot] = useState();

  useEffect(() => {
    getData();
  }, []);

  const getData = async () => {
    const res = await getListMedia({
      keyword: '',
      topic_id: '',
      platform: Platform.OS,
    });
    if (res.data.code == 200 && res.data.data) {
      if (res.data.data[0] && res.data.data[0].data[0])
        setMediaHot(res.data.data[0].data[0]);
      setData(res.data.data);
    } else {
      Alert.alert(I18n.t('Notification'), I18n.t('Can_not_get_data'));
    }
  };

  return <MediaView data={data} mediaHot={mediaHot} />;
};

export default Media;
