import React, {Component} from 'react';
import {AppRegistry, StyleSheet, Text, Image, View} from 'react-native';

import Swiper from 'react-native-swiper';
import R from '../../assets/R';
import {HEIGHTXD} from '../../Config/Functions';

const styles = StyleSheet.create({
  container: {
    marginHorizontal: 20,
    marginBottom: 10,
    borderRadius: 5,

    height: HEIGHTXD(400),
    marginTop: 25,
    borderBottomColor: R.colors.borderGray,
    borderTopColor: R.colors.borderGray,
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 1,
    },
    shadowOpacity: 0.25,
    shadowRadius: 2.84,
    elevation: 2,
  },
  text: {
    color: '#fff',
    fontSize: 30,
    fontWeight: 'bold',
  },
});

const SwiperComponent = (props) => {
  return (
    <View style={styles.container}>
      <Swiper
        dotColor={R.colors.color777}
        activeDotColor={R.colors.white}
        paginationStyle={{bottom: 5}}
        style={styles.wrapper}
        loop={true}
        autoplay={true}>
        <View style={{borderRadius: 10}}>
          <Image
            style={{height: HEIGHTXD(400), width: '100%', borderRadius: 5}}
            source={{uri: props.listImage[0].url}}
            resizeMode={'cover'}
          />
        </View>
        <View style={{borderRadius: 10}}>
          <Image
            style={{height: HEIGHTXD(400), width: '100%', borderRadius: 5}}
            source={{uri: props.listImage[1].url}}
            resizeMode={'cover'}
          />
        </View>
        <View style={{borderRadius: 10}}>
          <Image
            style={{height: HEIGHTXD(400), width: '100%', borderRadius: 5}}
            source={{uri: props.listImage[2].url}}
            resizeMode={'cover'}
          />
        </View>
      </Swiper>
    </View>
  );
};

export default SwiperComponent;
