import React, {useState} from 'react';
import {View, Text, StyleSheet, ScrollView} from 'react-native';
import HeaderBack from '../../../components/Header/HeaderBack';
import CheckBox from '@react-native-community/checkbox';
import R from '../../../assets/R';
import {getFontXD, toPriceVnd} from '../../../Config/Functions';
import AppText from '../../../components/AppText';

const ContainerTop = (props) => {
  const {fee} = props;
  const [isSelected, setSelection] = useState(false);
  return (
    <View style={styles.wrap}>
      {fee.data
        ? fee.data.map((e) => (
            <View key={e.id + 'a'} style={styles.item}>
              <View style={{flex: 1}}>
                <Text>{e.name}</Text>
              </View>
              <View
                style={{
                  width: 120,
                  marginRight: 30,
                  alignItems: 'flex-end',
                }}>
                {e.price_package.price == 0 ? (
                  <AppText
                    i18nKey={'Free'}
                    style={[styles.txtMoney, {color: '#18B918'}]}
                  />
                ) : (
                  <Text style={styles.txtMoney}>
                    {toPriceVnd(e.price_package.price)}
                  </Text>
                )}
              </View>
              <CheckBox
                value={true}
                disabled={true}
                onValueChange={setSelection}
                boxType={'square'}
              />
            </View>
          ))
        : null}
    </View>
  );
};

const styles = StyleSheet.create({
  container: {
    paddingHorizontal: 10,
    paddingTop: 10,
  },
  checkboxContainer: {
    flexDirection: 'row',
    marginBottom: 20,
  },
  checkbox: {
    alignSelf: 'flex-end',
  },
  txtNote: {
    fontStyle: 'italic',
  },
  wrap: {
    marginVertical: 10,
    backgroundColor: R.colors.white,
    paddingVertical: 10,
    paddingHorizontal: 10,
    borderRadius: 10,
    shadowColor: '#AFA9A9',
    shadowOffset: {
      width: 0,
      height: 1,
    },
    shadowOpacity: 0.25,
    shadowRadius: 1.84,
    elevation: 1,
  },
  item: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    alignItems: 'center',
    marginVertical: 10,
  },
  txtMoney: {
    fontSize: getFontXD(42),
    color: '#FFB721',
  },
  txtTitle: {
    fontSize: getFontXD(42),
    color: R.colors.main,
    marginTop: 10,
    fontWeight: 'bold',
  },
  txtGroup: {
    fontSize: getFontXD(42),
    color: R.colors.main,

    fontStyle: 'italic',
  },
});

export default ContainerTop;
