import React, {useState, useEffect} from 'react';
import {
  View,
  Text,
  Image,
  StyleSheet,
  TouchableOpacity,
  TouchableWithoutFeedback,
  Platform,
  Alert,
} from 'react-native';
import R from '../../assets/R';
import {HEIGHTXD, WIDTHXD, getFontXD} from '../../Config/Functions';
import Icon from 'react-native-vector-icons/AntDesign';
import Modal from 'react-native-modal';
import Block from '../Block';
import ImagePicker from 'react-native-image-crop-picker';
import AppText from '../AppText';
import {connect} from 'react-redux';
import {saveUserToRedux} from '../../actions/users';
import I18n from '../../helper/i18/i18n';
import {useNavigation} from '@react-navigation/native';
import {TABNAVIGATOR} from '../../routers/ScreenNames';
import {changeAvatart} from '../../apis/Functions/users';
import {showLoading, hideLoading} from '../../actions/loadingAction';

const options = {
  title: 'Select Avatar',
  customButtons: [{name: 'fb', title: 'Choose Photo from Facebook'}],
  storageOptions: {
    skipBackup: true,
    path: 'images',
  },
};

const PickerImg = (props) => {
  const naviagtion = useNavigation();
  const [isModalVisible, setModalVisible] = useState(false);
  const [imgAvatart, setImgAvatart] = useState(props.user.picture_url);

  //   useEffect(() => {
  //     setTimeout(() => {
  //       console.log('Affter', props.user.picture_url);
  //       setImgAvatart(props.user.picture_url);
  //     }, 500);
  //   }, [props.user]);

  const createFormData = (photo, body) => {
    const data = new FormData();
    data.append('avatar', {
      name: 'sign_img.jpg',
      type: 'image/jpg',
      uri: Platform.OS === 'android' ? photo : photo.replace('file://', ''),
    });
    Object.keys(body).forEach((key) => {
      data.append(key, body[key]);
    });
    return data;
  };

  const callApi = async (image) => {
    props.showLoading();
    const res = await changeAvatart(
      createFormData(image, {uid: props.user.uid, platform: Platform.OS}),
    );
    props.hideLoading();
    if (res.data.code == 200) {
      setTimeout(() => {
        props.saveUserToRedux(res.data.data);
        Alert.alert(I18n.t('Notification'), res.data.message);
      }, 500);
    } else {
      setImgAvatart(props.user.picture_url);
      setTimeout(() => {
        Alert.alert(I18n.t('Notification'), res.data.message);
      }, 500);
    }
  };

  const onchoosGalery = () => {
    ImagePicker.openPicker({
      mediaType: 'photo',
      multiple: false,
      cropping: true,
      width: 300,
      height: 300,
    }).then((image) => {
      setModalVisible(false);
      callApi(image.path);
      setImgAvatart(image.path);
    });
  };

  const onCapture = () => {
    ImagePicker.openCamera({
      mediaType: 'photo',
      multiple: false,
      width: 300,
      height: 300,
      cropping: true,
    }).then((image) => {
      setModalVisible(false);
      callApi(image.path);
      setImgAvatart(image.path);
    });
  };
  return (
    <TouchableOpacity onPress={() => setModalVisible(true)}>
      <View style={styles.containerImg}>
        {imgAvatart ? (
          <Image source={{uri: imgAvatart}} style={styles.imgAvatar} />
        ) : (
          <View style={styles.imgAvatar} />
        )}

        <View style={styles.iconPicker}>
          <Image
            style={{width: 20, height: 20}}
            source={R.images.imagePicker}
          />
        </View>
      </View>

      <Modal
        isVisible={isModalVisible}
        style={{margin: 0, justifyContent: 'flex-end'}}
        onSwipeComplete={() => setModalVisible(false)}
        swipeDirection={['up', 'left', 'right', 'down']}>
        <TouchableWithoutFeedback onPress={() => setModalVisible(false)}>
          <View style={{flex: 1}}></View>
        </TouchableWithoutFeedback>

        <View style={styles.containerSelect}>
          <AppText
            i18nKey={'Select_source_image'}
            style={{
              textAlign: 'center',
              fontSize: getFontXD(42),
              fontWeight: 'bold',
              color: '#1473E6',
            }}
          />

          <View style={styles.line} />
          <Block row space={'around'} center>
            <TouchableOpacity style={styles.selectionImg} onPress={onCapture}>
              <Image style={styles.imgIcon} source={R.images.iconCamera} />

              <AppText i18nKey={'Take_photo'} style={styles.txtTitleBtn} />
            </TouchableOpacity>
            <TouchableOpacity
              style={styles.selectionImg}
              onPress={onchoosGalery}>
              <Image style={styles.imgIcon} source={R.images.iconImg} />

              <AppText i18nKey={'Photo_library'} style={styles.txtTitleBtn} />
            </TouchableOpacity>
          </Block>
        </View>
      </Modal>
    </TouchableOpacity>
  );
};

const styles = StyleSheet.create({
  container: {
    width: WIDTHXD(350),
    height: HEIGHTXD(280),
    backgroundColor: R.colors.white,
    borderRadius: 10,
    borderWidth: 2,
    borderColor: '#DBDBDB',
    borderStyle: 'dashed',
    justifyContent: 'center',
    alignItems: 'center',
  },
  txt: {
    fontSize: getFontXD(42),
    color: R.colors.color777,
    marginBottom: 5,
    paddingLeft: 10,
  },
  selectionImg: {
    padding: 10,
    justifyContent: 'center',
    alignItems: 'center',
  },
  containerSelect: {
    height: HEIGHTXD(520),
    backgroundColor: 'white',
    paddingTop: 10,
    borderTopLeftRadius: 20,
    borderTopRightRadius: 20,
  },
  line: {
    height: 1,
    backgroundColor: '#929292',
    width: '100%',
    marginTop: 5,
  },
  imgIcon: {
    width: 40,
    height: 40,
  },
  txtTitleBtn: {
    textAlign: 'center',
    fontSize: getFontXD(42),
    color: '#1473E6',
  },
  imgAvatar: {
    width: WIDTHXD(180),
    height: WIDTHXD(180),
    borderRadius: WIDTHXD(90),
  },
  containerImg: {
    width: WIDTHXD(180),
    height: WIDTHXD(180),
  },
  iconPicker: {
    position: 'absolute',
    bottom: 0,
    right: 0,
  },
});

const mapStateToProps = (state) => {
  return {
    user: state.userReducer,
  };
};
export default connect(mapStateToProps, {
  saveUserToRedux,
  showLoading,
  hideLoading,
})(PickerImg);
