import React, {useEffect, useState} from 'react';
import {
    View,
    TouchableOpacity,
    Text,
    LayoutAnimation,
    StyleSheet
} from 'react-native';
import R from '../../../../../../assets/R';

import Ionicons from 'react-native-vector-icons/Ionicons';
import {getFontXD, getLineHeightXD, HEIGHTXD, WIDTHXD} from '../../../../../../Config/Functions';
import I18n from '../../../../../../helper/i18/i18n';
import TextField from '../../../../../../components/TextField';

const GeneralInfo = (props) => {
    const [expanded, setExpanded] = useState(true);
    const [contractDescription, setContractDescription] = useState(props.contractDescription);
    useEffect(() => {
        setContractDescription(props.contractDescription)
    }, [props.contractDescription])
    const changeLayout = () => {
        LayoutAnimation.configureNext({
            duration: 500,
            create: {
                type: LayoutAnimation.Types.spring,
                property: LayoutAnimation.Properties.scaleY,
                springDamping: 1.7,
            },
            update: {
                type: LayoutAnimation.Types.spring,
                springDamping: 1.7,
            },
        });
        setExpanded(!expanded)
    };

    return (
        <View style={styles.container}>
            <TouchableOpacity
                onPress={() => changeLayout()}
                style={[styles.flexTitle, { borderBottomWidth: expanded === true ? 0.3 : 0, paddingHorizontal: WIDTHXD(30) }]}
            >
                <Text style={styles.title}>{I18n.t('PriceInfo')}</Text>
                {expanded === true ? (
                    <Ionicons
                        name='chevron-up'
                        size={WIDTHXD(50)}
                        style={{ marginRight: WIDTHXD(50) }}
                        color={R.colors.iconGray}
                    />
                ) : (
                    <Ionicons
                        name='chevron-down'
                        size={WIDTHXD(50)}
                        style={{ marginRight: WIDTHXD(50) }}
                        color={R.colors.iconGray}
                    />
                )}
            </TouchableOpacity>
            {expanded ?
                <View style={{paddingVertical: HEIGHTXD(20)}}>
                    <TextField
                        title={I18n.t('ListedUnit')}
                        content={contractDescription?.price_quotation}
                    />
                    <TextField
                        title={I18n.t('PriceStep')}
                        content={contractDescription?.step_price}
                    />
                    <TextField
                        title={I18n.t('ContactSize')}
                        content={contractDescription?.contract_size}
                    />
                    <TextField
                        title={I18n.t('PriceRange')}
                        content={contractDescription && contractDescription.daily_price_limit ? `${I18n.t('FirstPriceRange')}: ${contractDescription.daily_price_limit}\n${I18n.t('ExpandPriceRange')}: ${contractDescription.expanded_price_limit}` : ''}
                    />
                </View>
                : null
            }
        </View>
    )

}
export default GeneralInfo
const styles = StyleSheet.create({
    container: {
        backgroundColor: R.colors.white,
        width: '100%',
        shadowColor: '#181F4D21',
        shadowOffset: {width: 1, height: 1},
        shadowOpacity: 1,
        shadowRadius: 2,
        elevation: 1,
    },
    flexTitle: {
        flexDirection: 'row',
        alignItems: 'center',
        justifyContent: 'space-between',
        paddingVertical: HEIGHTXD(36),
        borderBottomColor: R.colors.borderGray,
    },
    title: {
        fontSize: getFontXD(36),
        lineHeight: getLineHeightXD(56),
        color: R.colors.main,
        textTransform: 'uppercase',
    },
})
