import React, {Component} from 'react';
import {View, Text, StatusBar, SafeAreaView} from 'react-native';
import {getFontXD, HEIGHT, WIDTHXD} from '../../Config/Functions';
import Tab1 from './Tab1/Tab1';
import Tab2 from './Tab2/Tab2';
import Media from './Media/Media';
import Trading from './Tradding/Tradding';
import Calendar from './Calendar/Calendar';
import I18n from '../../helper/i18/i18n';

import {createMaterialTopTabNavigator} from '@react-navigation/material-top-tabs';
const Tab = createMaterialTopTabNavigator();
import HeaderDrawer from '../../components/Header/HeaderDrawer';

const NewFeed = (props) => {
  return (
    <View style={{flex: 1}}>
      <HeaderDrawer title={'News'} isWhite={true} />
      <View style={{flex: 1, backgroundColor: 'white'}}>
        <Tab.Navigator
          initialRouteName="GeneralInfor"
          swipeEnabled={false}
          tabBarOptions={{
            scrollEnabled: true,
            inactiveTintColor: '#929292',
            activeTintColor: '#1473E6',
            labelStyle: {fontSize: getFontXD(36)},
            style: {backgroundColor: 'white'},
          }}>
          <Tab.Screen
            name="Tab1"
            component={Tab1}
            options={{tabBarLabel: I18n.t('News')}}
          />
          <Tab.Screen
            name="Tab2"
            component={Media}
            options={{tabBarLabel: 'Media'}}
          />
          <Tab.Screen
            name="Tab3"
            component={Tab2}
            options={{tabBarLabel: I18n.t('PriceTable')}}
          />
          <Tab.Screen
            name="Tab4"
            component={Trading}
            options={{tabBarLabel: I18n.t('Chart')}}
          />
          <Tab.Screen
            name="CALENDAR"
            component={Calendar}
            options={{tabBarLabel: I18n.t('Calendar')}}
          />
        </Tab.Navigator>
      </View>
    </View>
  );
};

export default NewFeed;
