import React, {useEffect, useState} from 'react';
import {View, Text, StyleSheet, FlatList, Platform, Alert} from 'react-native';
import R from '../../../assets/R';
import HeaderBack from '../../../components/Header/HeaderBack';
import Item from './Item';
import {getListWidthDraw} from '../../../apis/Functions/Widthdraw';
import {connect} from 'react-redux';
import I18n from '../../../helper/i18/i18n';

const WithdrawView = (props) => {
  const [data, setData] = useState([]);

  useEffect(() => {
    getData();
  }, []);

  const getData = async () => {
    const res = await getListWidthDraw({
      platform: Platform.OS,
    });
    if (res.data.code == 200 && res.data.data) {
      setData(res.data.data);
    } else {
      Alert.alert(I18n.t('Notification'), I18n.t('Can_not_get_data'));
    }
  };

  return (
    <View style={{flex: 1}}>
      <HeaderBack title={'SelectPaymentMethod'} />
      <View style={{flex: 1}}>
        <FlatList
          keyExtractor={(item) => item.id}
          showsVerticalScrollIndicator={false}
          numColumns={2}
          columnWrapperStyle={{
            marginHorizontal: 20,
            justifyContent: 'space-between',
          }}
          data={data}
          renderItem={({item}) => <Item userId={props.user.uid} item={item} />}
        />
      </View>
    </View>
  );
};

const mapStateToProps = (state) => {
  return {
    user: state.userReducer,
  };
};
export default connect(mapStateToProps, {})(WithdrawView);
