import React, {useEffect} from 'react';
import {View, Text} from 'react-native';
import {createBottomTabNavigator} from '@react-navigation/bottom-tabs';
import Icon from 'react-native-vector-icons/FontAwesome5';
import Ionicons from 'react-native-vector-icons/Ionicons';

import Home from '../Screens/Home/Home';
import {connect} from 'react-redux';
import R from '../assets/R';
import PlussModal from './PlussModal';

import Account from '../Screens/Account/Account';
import Exchange from '../Screens/Exchange/Exchange';
import NewFeed from '../Screens/NewFeed/NewFeed';
import Notification from '../Screens/Notification/Notification';
import Test from '../Screens/NewFeed/Test';
const Tab = createBottomTabNavigator();

const PayScreenComponent = () => {
  return null;
};

const TabNavigator = (props) => {
  return (
    <View style={{flex: 1}}>
      <Tab.Navigator
        initialRouteName="Screen1"
        tabBarOptions={{activeTintColor: R.colors.main}}>
        <Tab.Screen
          name="Screen1"
          component={Home}
          options={{
            tabBarLabel: 'Overview',
            tabBarIcon: ({color, size}) => (
              <Icon name="landmark" size={size} color={color} />
            ),
          }}
        />

        <Tab.Screen
          name="Screen2"
          component={Account}
          options={{
            tabBarLabel: 'Tài khoản',
            tabBarIcon: ({color, size}) => (
              <Icon name="user-tie" size={size} color={color} />
            ),
          }}
        />

        <Tab.Screen
          name="Pay"
          component={PayScreenComponent}
          options={{
            tabBarButton: () => <PlussModal />,
          }}
        />

        <Tab.Screen
          name="Screen3"
          component={Notification}
          options={{
            tabBarLabel: 'Thông báo',
            tabBarIcon: ({color, size}) => (
              <Ionicons
                name="ios-notifications-outline"
                size={size}
                color={color}
              />
            ),
          }}
        />
        <Tab.Screen
          name="Screen4"
          component={NewFeed}
          options={{
            tabBarLabel: 'Tin tức',
            tabBarIcon: ({color, size}) => (
              <Ionicons name="newspaper-outline" size={size} color={color} />
            ),
          }}
        />
      </Tab.Navigator>
    </View>
  );
};

const mapStateToProps = (state) => {
  return {
    notifi: state.CountNotificationReducer,
  };
};

export default connect(mapStateToProps, {})(TabNavigator);
