import React, {Component, useState} from 'react';
import {
  View,
  Text,
  TouchableOpacity,
  StyleSheet,
  Button,
  TouchableWithoutFeedback,
  Image,
} from 'react-native';
import Icon from 'react-native-vector-icons/Entypo';
import R from '../assets/R';
import {HEIGHTXD, WIDTHXD, getFontXD} from '../Config/Functions';
import Modal from 'react-native-modal';

import {useNavigation} from '@react-navigation/native';
import {
  WITHDRAW,
  DEPOSIT,
  TRANSFER,
  CHOOSEMETHOD,
  WALLET,
  WALLETWITHDRAW,
} from '../routers/ScreenNames';

const PlussModal = (props) => {
  const [isModalVisible, setModalVisible] = useState(false);

  const navigate = useNavigation();

  const toggleModal = () => {
    setModalVisible(!isModalVisible);
  };

  return (
    <View style={styles.container}>
      <View style={styles.wraper}>
        <TouchableOpacity onPress={toggleModal} style={styles.btn}>
          <Icon name={'plus'} size={27} color={R.colors.white} />
        </TouchableOpacity>
      </View>

      <Modal style={{margin: 0}} isVisible={isModalVisible}>
        <View style={{flex: 1}}>
          <TouchableWithoutFeedback onPress={toggleModal}>
            <View style={{flex: 1}}></View>
          </TouchableWithoutFeedback>
          <View style={styles.footer}>
            <TouchableOpacity
              onPress={() => {
                navigate.navigate(WALLET);
                toggleModal();
              }}
              style={styles.wraper1}>
              <Image style={styles.imgIcon} source={R.images.iconWallet1} />
              <Text style={styles.txt}>Ví tiền</Text>
            </TouchableOpacity>
            <TouchableOpacity
              onPress={() => {
                navigate.navigate(CHOOSEMETHOD);
                toggleModal();
              }}
              style={styles.wraper1}>
              <Image style={styles.imgIcon} source={R.images.iconRecharge} />
              <Text style={styles.txt}>Nạp tiền</Text>
            </TouchableOpacity>
            <TouchableOpacity
              onPress={() => {
                navigate.navigate(WALLETWITHDRAW);
                toggleModal();
              }}
              style={styles.wraper1}>
              <Image style={styles.imgIcon} source={R.images.iconWithdrawal} />
              <Text style={styles.txt}>Rút tiền</Text>
            </TouchableOpacity>
            <TouchableOpacity
              onPress={() => {
                navigate.navigate(TRANSFER);
                toggleModal();
              }}
              style={styles.wraper1}>
              <Image style={styles.imgIcon} source={R.images.iconTransfer} />
              <Text style={styles.txt}>Chuyển khoản</Text>
            </TouchableOpacity>
          </View>
        </View>
      </Modal>
    </View>
  );
};

export default PlussModal;

const styles = StyleSheet.create({
  btn: {
    backgroundColor: R.colors.main,
    width: WIDTHXD(144),
    height: WIDTHXD(144),
    justifyContent: 'center',
    alignItems: 'center',
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 2,
    },
    shadowOpacity: 0.25,
    shadowRadius: 3.84,
    elevation: 3,
    borderRadius: 30,
  },
  container: {
    flex: 1,
  },
  wraper: {
    backgroundColor: R.colors.white,
    width: WIDTHXD(160),
    height: WIDTHXD(160),
    justifyContent: 'center',
    alignItems: 'center',
    position: 'absolute',
    top: -20,
    left: 15,
    borderRadius: WIDTHXD(90),
  },
  footer: {
    backgroundColor: 'white',
    height: HEIGHTXD(400),
    borderTopLeftRadius: 10,
    borderTopRightRadius: 10,
    justifyContent: 'space-around',
    alignItems: 'center',
    flexDirection: 'row',
  },
  imgIcon: {
    width: WIDTHXD(150),
    height: HEIGHTXD(150),
    resizeMode: 'contain',
  },
  wraper1: {
    justifyContent: 'center',
    alignItems: 'center',
    width: 100,
  },
  txt: {
    fontSize: getFontXD(36),
    color: R.colors.txtMain,
    marginTop: 5,
  },
});
