import React, {useEffect, useState} from 'react';
import {
  View,
  Text,
  Image,
  StatusBar,
  StyleSheet,
  SafeAreaView,
  ImageBackground,
  TouchableOpacity,
  Platform,
  Alert,
} from 'react-native';
import R from '../../assets/R';
import {getFontXD, HEIGHT, WIDTHXD} from '../../Config/Functions';
import LinearGradient from 'react-native-linear-gradient';
import {connect} from 'react-redux';
import {HEIGHTXD, toPriceVnd} from '../../Config/Functions';
import Clipboard from '@react-native-clipboard/clipboard';

import {useNavigation} from '@react-navigation/native';
import {
  WITHDRAW,
  DEPOSIT,
  CHOOSEMETHOD,
  TRANSFER,
  HISTORY,
  PROFILE,
  AccountVerification,
  WALLETWITHDRAW,
} from '../../routers/ScreenNames';

const renderWallet = (status, current_money, current_cqg_money) => {
  const navigate = useNavigation();
  if (status == 3)
    return (
      <View style={{flex: 1, flexDirection: 'row'}}>
        <View style={styles.containerWallet}>
          <Text style={styles.txtWallet}>Tài khoản ví</Text>
          <View style={{flexDirection: 'row'}}>
            <Text style={styles.txtMoney}>
              {current_money == 0 ? 0 : toPriceVnd(current_money)}
            </Text>
            <Text style={styles.txtUnit}>Đ</Text>
          </View>
        </View>
        <View style={{width: 1, backgroundColor: '#EDEDF1', height: '100%'}} />
        <View style={styles.containerWallet}>
          <Text style={styles.txtWallet}>Tài khoản CQG</Text>
          <View style={{flexDirection: 'row'}}>
            <Text style={styles.txtMoney}>
              {current_cqg_money == 0 ? 0 : toPriceVnd(current_cqg_money)}
            </Text>
            <Text style={styles.txtUnit}>Đ</Text>
          </View>
        </View>
      </View>
    );
  if (status == 4)
    return (
      <View style={{flex: 1, flexDirection: 'row'}}>
        <View style={styles.containerWallet}>
          <Text style={styles.txtWallet}>Tài khoản ví</Text>
          <View style={{flexDirection: 'row'}}>
            <Text style={styles.txtMoney}>{toPriceVnd(1000000)}</Text>
            <Text style={styles.txtUnit}>Đ</Text>
          </View>
        </View>
        <View style={{width: 1, backgroundColor: '#EDEDF1', height: '100%'}} />

        <View style={styles.containerWallet}>
          <TouchableOpacity style={styles.btn}>
            <Text style={styles.txtWhite}>Mở tài khoản thật</Text>
          </TouchableOpacity>
        </View>
      </View>
    );

  return (
    <View style={{flex: 1, justifyContent: 'center', alignItems: 'center'}}>
      <TouchableOpacity
        disabled={status == 2 ? true : false}
        onPress={() => navigate.navigate(AccountVerification)}>
        <ImageBackground
          imageStyle={{borderRadius: 10}}
          style={{
            width: 320,
            height: 60,
            borderRadius: 10,
            justifyContent: 'center',
            alignItems: 'center',
          }}
          source={R.images.iconBtnGreen}>
          <Text style={{fontSize: getFontXD(52), color: 'white'}}>
            {status == 2 ? 'Chờ xác minh' : 'Xác minh tài khoản'}
          </Text>
        </ImageBackground>
      </TouchableOpacity>
    </View>
  );
};

const renderLabel = (status) => {
  if (status == 1) return <Text style={{color: '#E3434F'}}>Chưa xác minh</Text>;
  if (status == 2) return <Text style={{color: '#FFB721'}}>Chờ xác minh</Text>;
  if (status == 3) return <Text style={{color: '#17B217'}}>Đã xác minh</Text>;
};

const HeaderHome = (props) => {
  const navigate = useNavigation();
  console.log(props.user);

  const copyToClipboard = () => {
    Alert.alert('Đã sao chép link giới thiệu!');
    Clipboard.setString(props.user.sponsor_url);
  };

  return (
    <View style={styles.container}>
      <StatusBar backgroundColor="transparent" translucent={true} />
      <View
        style={{
          justifyContent: 'center',
          alignItems: 'center',
        }}>
        <View style={styles.containerTop}>
          <View style={styles.containerInfor}>
            <Image source={R.images.avartar} style={styles.imgAvatar} />
            <View style={styles.wrapRight}>
              <TouchableOpacity onPress={() => navigate.navigate(PROFILE)}>
                <View style={{flexDirection: 'row', alignItems: 'center'}}>
                  <Text style={styles.txtName}>{props.user.fullname}</Text>
                  {props.user.status == 3 ? (
                    <Image
                      source={R.images.iconCheck}
                      style={{width: 20, height: 20, marginLeft: 20}}
                    />
                  ) : null}
                </View>
              </TouchableOpacity>

              <View style={styles.row1}>
                <Text style={styles.txtlink}>ID:{props.user.user_id}</Text>
                <TouchableOpacity onPress={copyToClipboard}>
                  <Image
                    source={R.images.iconCopy}
                    style={styles.imgIconCopy}
                  />
                </TouchableOpacity>
              </View>
              {renderLabel(props.user.status)}
            </View>
          </View>

          <View style={styles.wrapWallet}>
            {renderWallet(
              props.user.status,
              props.user.current_money,
              props.user.current_cqg_money,
            )}
          </View>
          <View style={styles.containerMenu}>
            <TouchableOpacity
              onPress={() => navigate.navigate(CHOOSEMETHOD)}
              style={styles.wraper}>
              <Image style={styles.imgIcon} source={R.images.iconRecharge} />
              <Text style={styles.txt}>Nạp tiền</Text>
            </TouchableOpacity>

            <TouchableOpacity
              onPress={() => navigate.navigate(WALLETWITHDRAW)}
              style={styles.wraper}>
              <Image style={styles.imgIcon} source={R.images.iconWithdrawal} />
              <Text style={styles.txt}>Rút tiền</Text>
            </TouchableOpacity>
            <TouchableOpacity
              onPress={() => navigate.navigate(TRANSFER)}
              style={styles.wraper}>
              <Image style={styles.imgIcon} source={R.images.iconTransfer} />
              <Text style={styles.txt}>Chuyển khoản</Text>
            </TouchableOpacity>
            <TouchableOpacity
              onPress={() => navigate.navigate(HISTORY)}
              style={styles.wraper}>
              <Image style={styles.imgIcon} source={R.images.iconHistory} />
              <Text style={styles.txt}>Lịch sử</Text>
            </TouchableOpacity>
          </View>
        </View>
      </View>
    </View>
  );
};

const mapStateToProps = (state) => {
  return {
    user: state.userReducer,
  };
};

export default connect(mapStateToProps, {})(HeaderHome);

const styles = StyleSheet.create({
  container: {},
  wrapWallet: {
    height: 80,
    width: '100%',
    borderBottomWidth: 1,
    borderBottomColor: '#EDEDF1',
  },
  img: {
    height: Platform.OS == 'ios' ? HEIGHTXD(728) : HEIGHTXD(808),
    width: '100%',

    justifyContent: 'center',
    alignItems: 'center',
  },
  containerTop: {
    backgroundColor: 'white',
    height: 290,
    width: '90%',
    borderRadius: 10,
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 1,
    },
    shadowOpacity: 0.25,
    shadowRadius: 2.84,
    elevation: 3,
    marginTop: HEIGHTXD(150),
  },
  containerMenu: {
    justifyContent: 'space-between',
    alignItems: 'center',
    flexDirection: 'row',
    padding: 10,
  },
  wraper: {
    justifyContent: 'center',
    alignItems: 'center',
  },
  imgIcon: {
    width: WIDTHXD(134),
    height: HEIGHTXD(134),
    marginBottom: 10,
    resizeMode: 'contain',
  },
  imgIconCopy: {
    width: WIDTHXD(134),
    height: HEIGHTXD(134),

    resizeMode: 'contain',
  },
  txt: {
    fontSize: getFontXD(36),
    color: R.colors.txtMain,
  },
  txtWallet: {
    fontSize: getFontXD(36),
    color: R.colors.txtMain,
    marginBottom: 5,
  },
  txtName: {
    fontSize: getFontXD(52),
    color: '#00359C',
  },
  txtlink: {
    fontSize: getFontXD(42),
    color: '#A2A2A2',
  },
  imgAvatar: {
    width: WIDTHXD(240),
    height: WIDTHXD(240),
    borderRadius: WIDTHXD(120),
  },
  txtMoney: {
    fontSize: getFontXD(62),
    color: '#FFB721',
    marginVertical: 5,
    fontWeight: 'bold',
  },
  txtTitle: {
    fontSize: getFontXD(42),
    color: '#A2A2A2',
    fontWeight: 'bold',
    marginTop: 5,
    marginLeft: 5,
  },
  wrapRight: {
    flex: 1,
    paddingHorizontal: 20,
  },
  containerInfor: {
    flex: 1,
    justifyContent: 'center',
    alignItems: 'center',
    borderBottomWidth: 1,
    borderBottomColor: '#EDEDF1',
    flexDirection: 'row',
    paddingHorizontal: 20,
  },
  row: {
    flexDirection: 'row',
    alignItems: 'center',
    marginTop: 5,
  },
  row1: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    alignItems: 'center',
  },
  containerWallet: {
    justifyContent: 'center',
    alignItems: 'center',
    flex: 1,
  },
  txtMoney: {
    fontSize: getFontXD(46),
    color: '#FFB721',
  },
  txtUnit: {
    fontSize: getFontXD(46),
    marginLeft: 10,
    color: '#A2A2A2',
  },
  txtWhite: {
    fontSize: getFontXD(36),
    color: R.colors.white,
    textTransform: 'uppercase',
    fontWeight: 'bold',
  },
  btn: {
    paddingHorizontal: 10,
    paddingVertical: 10,
    backgroundColor: R.colors.main,
    borderRadius: 10,
    shadowColor: '#AFA9A9',
    shadowOffset: {
      width: 0,
      height: 1,
    },
    shadowOpacity: 0.25,
    shadowRadius: 1.84,
    elevation: 1,
  },
});
