import React, {useState} from 'react';
import {View, Text, Switch, StyleSheet} from 'react-native';
import HeaderBack from '../../components/Header/HeaderBack';
import Block from '../../components/Block';
import {getFontXD} from '../../Config/Functions';
import PickerItem from '../../components/Picker/PickerItem';

const dataTest = [
  {
    value: '1',
    name: 'Vietnamese',
  },
  {
    value: '2',
    name: 'English',
  },
];

const SettingView = (props) => {
  const [isEnabled, setIsEnabled] = useState(true);
  const toggleSwitch = () => setIsEnabled((previousState) => !previousState);

  const [language, setLanguage] = useState(dataTest[0].name);

  return (
    <View style={{flex: 1}}>
      <HeaderBack title={'Cài đặt'} />
      <View style={{flex: 1, padding: 10}}>
        <View style={styles.row}>
          <Text style={styles.txtTitle}>Bật thông báo</Text>
          <Switch
            trackColor={{false: '#DBDBDB', true: '#1C6AF6'}}
            ios_backgroundColor="#767577"
            thumbColor={'#f4f3f4'}
            onValueChange={toggleSwitch}
            value={isEnabled}
          />
        </View>

        <View style={styles.row}>
          <Text style={styles.txtTitle}>Ngôn ngữ</Text>
          <PickerItem
            defaultValue={language}
            width={200}
            value={language}
            data={dataTest}
            onValueChange={(value, items) => {
              setLanguage(items.name);
            }}
          />
        </View>
      </View>

      <Text>SettingView 1 screen</Text>
    </View>
  );
};

export default SettingView;
const styles = StyleSheet.create({
  txtTitle: {
    fontSize: getFontXD(46),
    color: '#001C51',
  },

  row: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    alignItems: 'center',
    marginBottom: 20,
  },
});
