import React, {useState} from 'react';
import {
  View,
  Text,
  FlatList,
  StyleSheet,
  TouchableOpacity,
  ScrollView,
} from 'react-native';

import HeaderDrawer from '../../components/Header/HeaderDrawer';
import Item from './Item';
import {getFontXD} from '../../Config/Functions';

const Fillters = [
  {
    id: '1',
    name: 'Tất cả',
    value: 'ALL',
  },
  {
    id: '2',
    name: 'Nạp tiền',
    value: 'DEPOSIT',
  },
  {
    id: '3',
    name: 'Rút tiền',
    value: 'WITHDRAW',
  },
  {
    id: '4',
    name: 'Chuyển khoản',
    value: 'TRANSFER',
  },
];

const NotificaitonView = (props) => {
  const {onRefresh, isRefresh, onLoadMore, setFillters, fillter, data} = props;

  return (
    <View style={{flex: 1}}>
      <HeaderDrawer isWhite={true} title={'Thông báo'} />

      <View style={styles.headerContainer}>
        <ScrollView horizontal showsHorizontalScrollIndicator={false}>
          {Fillters.map((e) => (
            <TouchableOpacity
              key={e.value}
              onPress={() => setFillters(e.value)}
              style={[
                styles.itemFillter,
                fillter == e.value ? {borderColor: '#1473E6'} : null,
              ]}>
              <Text
                style={[
                  styles.txtFillter,
                  fillter == e.value ? {color: '#1473E6'} : {},
                ]}>
                {e.name}
              </Text>
            </TouchableOpacity>
          ))}
        </ScrollView>
      </View>

      {data.length == 0 ? (
        <View style={{justifyContent: 'center', alignItems: 'center', flex: 1}}>
          <Text
            style={{
              fontSize: getFontXD(46),
              fontWeight: 'bold',
            }}>
            Không có thông báo nào!
          </Text>
        </View>
      ) : (
        <FlatList
          keyExtractor={(item) => item.id}
          data={data}
          refreshing={isRefresh}
          onRefresh={onRefresh}
          onEndReachedThreshold={0.01}
          onEndReached={(info) => {
            onLoadMore();
          }}
          renderItem={({item}) => <Item item={item} />}
        />
      )}
    </View>
  );
};

const styles = StyleSheet.create({
  headerContainer: {
    paddingVertical: 10,
    backgroundColor: 'white',
    flexDirection: 'row',
    alignItems: 'center',
    paddingHorizontal: 10,
  },
  itemFillter: {
    borderRadius: 10,
    paddingVertical: 5,
    paddingHorizontal: 10,
    borderWidth: 1,
    borderColor: '#929292',
    justifyContent: 'center',
    alignItems: 'center',
    marginRight: 10,
  },
  txtFillter: {
    fontSize: getFontXD(36),
    color: '#929292',
    fontWeight: 'bold',
  },
  txtTitle: {
    fontSize: getFontXD(46),
    fontWeight: 'bold',
  },
});

export default NotificaitonView;
