import React, {useState, useEffect} from 'react';
import {
  View,
  Text,
  StyleSheet,
  ImageBackground,
  TouchableOpacity,
  FlatList,
} from 'react-native';
import YouTube from 'react-native-youtube';
import R from '../../../assets/R';
import HeaderBack from '../../../components/Header/HeaderBack';
import {getFontXD} from '../../../Config/Functions';
import Icon from 'react-native-vector-icons/AntDesign';
import {useNavigation} from '@react-navigation/native';
import {MEDIADETAIL} from '../../../routers/ScreenNames';
import {getDetailMedia} from '../../../apis/Functions/NewFeed';

const Item = (props) => {
  const navigate = useNavigation();

  const {title, poster, published_at, id} = props.item;

  return (
    <TouchableOpacity
      onPress={() => props.onChangeID(id)}
      style={styles.containerItem}>
      <ImageBackground
        resizeMode={'cover'}
        imageStyle={{borderRadius: 5, width: 140, height: 100}}
        style={styles.img}
        source={{uri: poster}}>
        <Icon
          name={'playcircleo'}
          color={R.colors.white}
          size={getFontXD(52)}
        />
      </ImageBackground>
      <View style={styles.wrapRight}>
        <View style={{flex: 1}}>
          <Text style={styles.txtTitle} numberOfLines={2}>
            {title}
          </Text>
        </View>
        <Text>{published_at}</Text>
      </View>
    </TouchableOpacity>
  );
};

const MediaDetail = (props) => {
  const [id, setID] = useState(props.route.params.id);
  const [data, setData] = useState();

  useEffect(() => {
    getData();
  }, [id]);
  const onChangeID = (item) => setID(item);

  const getData = async () => {
    const res = await getDetailMedia(id);
    if (res.data.code == 200 && res.data.data) {
      setData(res.data.data);
    } else {
      Alert.alert('Thông báo', 'Không lấy được dữ liệu!');
    }
  };
  return (
    <View style={{flex: 1}}>
      <HeaderBack title={'Chi tiết video'} />
      {data ? (
        <View style={{flex: 1}}>
          <YouTube
            apiKey={'AIzaSyAMj3UyhieazgdBFGeZ33V6C3zweAYpvP8'}
            videoId={data.video_id}
            play={false}
            onError={(e) => console.log({error: e.error})}
            style={{alignSelf: 'stretch', height: 250}}
          />
          <View style={styles.wrapTitle}>
            <Text style={styles.txtTitle}>{data.title}</Text>
          </View>
          <View style={styles.body}>
            <Text style={styles.txtBig}>Video xem nhiều</Text>
            <FlatList
              showsVerticalScrollIndicator={false}
              data={data.related_videos}
              renderItem={({item}) => (
                <Item onChangeID={onChangeID} item={item} />
              )}
              keyExtractor={(item) => item.id}
            />
          </View>
        </View>
      ) : null}
    </View>
  );
};

const styles = StyleSheet.create({
  txtTitle: {
    fontSize: getFontXD(42),
  },
  txtBig: {
    fontSize: getFontXD(46),
    fontWeight: 'bold',
  },
  wrapTitle: {
    paddingVertical: 10,
    paddingHorizontal: 10,
    borderBottomWidth: 0.7,
    borderBottomColor: R.colors.borderGray,
  },
  body: {
    paddingHorizontal: 10,
    paddingTop: 10,
    flex: 1,
  },
  img: {
    width: 140,
    height: 100,
    borderRadius: 5,
    justifyContent: 'center',
    alignItems: 'center',
  },
  containerItem: {
    flexDirection: 'row',
    paddingVertical: 10,
    borderBottomColor: R.colors.borderGray,
    borderBottomWidth: 0.7,
  },
  wrapRight: {
    flex: 1,
    marginLeft: 10,
  },
});

export default MediaDetail;
