import React, {Component, useEffect, useState} from 'react';
import {View, Text, Platform, Alert} from 'react-native';

import MediaView from './MediaView';
import {getListMedia} from '../../../apis/Functions/NewFeed';

const Media = (props) => {
  const [data, setData] = useState([]);
  const [mediaHot, setMediaHot] = useState();

  useEffect(() => {
    getData();
  }, []);

  const getData = async () => {
    const res = await getListMedia({
      keyword: '',
      topic_id: '',
      platform: Platform.OS,
    });
    if (res.data.code == 200 && res.data.data) {
      if (res.data.data[0] && res.data.data[0].data[0])
        setMediaHot(res.data.data[0].data[0]);
      setData(res.data.data);
    } else {
      Alert.alert('Thông báo', 'Không lấy được dữ liệu!');
    }
  };

  return <MediaView data={data} mediaHot={mediaHot} />;
};

export default Media;
