import React from 'react';
import {View, Text, StyleSheet, FlatList, TouchableOpacity} from 'react-native';
import R from '../../assets/R';
import HeaderBack from '../../components/Header/HeaderBack';
import Item from './Item';
import {WIDTHXD} from '../../Config/Functions';
import Icon from 'react-native-vector-icons/Entypo';
import {useNavigation} from '@react-navigation/native';
import {ADDMETHODPAY} from '../../routers/ScreenNames';

const MethodPayView = (props) => {
  const navigate = useNavigation();

  const {isRefresh, listMethod, onRefresh} = props;

  return (
    <View style={{flex: 1}}>
      <HeaderBack title={'Cài đặt phương thức thanh toán'} />
      <View style={{flex: 1}}>
        <FlatList
          keyExtractor={(item) => item.method}
          showsVerticalScrollIndicator={false}
          refreshing={isRefresh}
          onRefresh={onRefresh}
          onEndReachedThreshold={0.01}
          data={listMethod}
          renderItem={({item}) => <Item item={item} />}
        />

        <TouchableOpacity
          onPress={() => navigate.navigate(ADDMETHODPAY)}
          style={styles.containerBtn}>
          <Icon name={'plus'} size={27} color={R.colors.white} />
        </TouchableOpacity>
      </View>
    </View>
  );
};

const styles = StyleSheet.create({
  containerBtn: {
    backgroundColor: R.colors.main,
    position: 'absolute',
    bottom: 30,
    right: 20,
    width: WIDTHXD(144),
    height: WIDTHXD(144),
    justifyContent: 'center',
    alignItems: 'center',
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 2,
    },
    shadowOpacity: 0.25,
    shadowRadius: 3.84,
    elevation: 3,
    borderRadius: 30,
  },
});

export default MethodPayView;
