import React, {useState, useEffect} from 'react';
import {
  View,
  Text,
  StyleSheet,
  FlatList,
  Dimensions,
  TouchableOpacity,
  Alert,
  KeyboardAvoidingView,
  TouchableWithoutFeedback,
  Keyboard,
  Platform,
} from 'react-native';
import {connect} from 'react-redux';
import R from '../../assets/R';
import HeaderBack from '../../components/Header/HeaderBack';

import Item from './Item';
import {getFontXD, WIDTHXD, checkFormatArray} from '../../Config/Functions';
import TextField from '../../components/Input/TextField';
import PickerItem from '../../components/Picker/PickerItem';
import {
  deleteMethodBank,
  addMethodBank,
  updateMethodBank,
} from '../../apis/Functions/Widthdraw';
import {showLoading, hideLoading} from '../../actions/loadingAction';
import {useNavigation} from '@react-navigation/native';
import BankInfor from '../../components/BankInfor';
const {width} = Dimensions.get('window');

const MethodPayDetail = (props) => {
  const [data, setData] = useState([]);
  const {params} = props.route;

  const [disable, setDisable] = useState(true);
  const navigate = useNavigation();
  const [branch_name, setBankName] = useState(params.branch_name);
  const [account_name, setAccountName] = useState(params.account_name);
  const [account_no, setAccountNo] = useState(params.account_no);

  const onUpdate = async () => {
    const titles = ['chi nhánh', 'chủ tài khoản', 'số tài khoản ngân hàng'];
    const index = checkFormatArray([branch_name, account_name, account_no]);
    if (index === true) {
      if (
        branch_name != params.branch_name ||
        account_name != params.account_name ||
        account_no != params.account_no
      ) {
        props.showLoading();
        const res = await updateMethodBank({
          platform: Platform.OS,
          id: params.id,
          branch_name,
          account_name,
          account_no,
        });
        props.hideLoading();
        if (res.data.code == 200) {
          setTimeout(() => {
            Alert.alert('Thông báo!', res.data.message);
            navigate.goBack();
          }, 500);
        } else {
          setTimeout(() => {
            Alert.alert('Thông báo!', res.data.message);
          }, 500);
        }
      } else {
        Alert.alert('Thông báo!', 'Không có gì thay đổi');
      }
    } else Alert.alert('Thông báo!', 'Vui lòng điền ' + titles[index]);
  };

  const onRemove = async () => {
    props.showLoading();
    const res = await deleteMethodBank({
      platform: Platform.OS,
      id: params.id,
    });
    props.hideLoading();
    if (res.data.code == 200) {
      setTimeout(() => {
        Alert.alert('Thông báo!', res.data.message);
        navigate.goBack();
      }, 500);
    } else {
      setTimeout(() => {
        Alert.alert('Thông báo!', res.data.message);
      }, 500);
    }
  };

  return (
    <KeyboardAvoidingView
      behavior={Platform.Os === 'ios' ? 'padding' : 'height'}
      style={{flex: 1}}
      keyboardVerticalOffset={-50}>
      <TouchableWithoutFeedback onPress={Keyboard.dismiss}>
        <View style={{flex: 1}}>
          <HeaderBack title={'Chi tiết phương thức'} />
          <View style={{flex: 1}}>
            <View style={styles.container}>
              <BankInfor
                linkImg={params.bank.logo}
                title={'Chọn ngân hàng'}
                value={params.bank.name}
              />
              <TextField
                onChangeText={(val) => setBankName(val)}
                title={'Chi nhánh'}
                value={branch_name}
              />

              <TextField
                onChangeText={(val) => setAccountName(val)}
                title={'Tên chủ tài khoản'}
                value={account_name}
              />
              <TextField
                onChangeText={(val) => setAccountNo(val)}
                title={'Số tài khoản ngân hàng'}
                isNumber={true}
                value={account_no}
              />
            </View>
          </View>
          <View style={styles.footer}>
            <TouchableOpacity onPress={onUpdate} style={styles.btnLeft}>
              <Text style={styles.txtAdd}>Cập nhật</Text>
            </TouchableOpacity>
            <TouchableOpacity
              onPress={() => {
                Alert.alert(
                  'Thông báo!',
                  'Bạn có chắc chắn muốn xoá phương thức thanh toán',
                  [
                    {
                      text: 'Từ chối',
                      style: 'cancel',
                    },
                    {text: 'Đồng ý', onPress: () => onRemove()},
                  ],
                );
              }}
              style={styles.btnRight}>
              <Text style={styles.txtAdd}>Xoá</Text>
            </TouchableOpacity>
          </View>
        </View>
      </TouchableWithoutFeedback>
    </KeyboardAvoidingView>
  );
};

const styles = StyleSheet.create({
  container: {
    paddingHorizontal: 20,
    paddingTop: 10,
  },
  footer: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'space-between',
    marginBottom: 10,
    paddingHorizontal: 20,
  },
  btnLeft: {
    width: 150,
    height: 40,
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: R.colors.main,
    borderRadius: 5,
  },
  btnRight: {
    width: 150,
    height: 40,
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: R.colors.main,
    borderRadius: 5,
  },
  txtAdd: {
    color: R.colors.white,
    fontSize: getFontXD(46),
    textTransform: 'uppercase',
    fontWeight: 'bold',
  },
  txtTitle: {
    fontSize: getFontXD(42),
    color: R.colors.color777,
    marginBottom: 5,
  },
});

const mapStateToProps = (state) => {
  return {
    user: state.userReducer,
  };
};
export default connect(mapStateToProps, {
  showLoading,
  hideLoading,
})(MethodPayDetail);
