import React, {useState, useEffect} from 'react';

import MethodPayView from './MethodPayView';
import {getListWidthDraw} from '../../apis/Functions/Widthdraw';
import {useNavigation} from '@react-navigation/native';

const MethodPay = (props) => {
  const [data, setData] = useState([]);
  const [isRefresh, setRefresh] = useState(false);

  useEffect(() => {
    getData();
  }, []);

  const onRefresh = () => {
    getData();
  };

  const getData = async () => {
    setRefresh(true);
    const res = await getListWidthDraw({
      platform: Platform.OS,
    });
    setRefresh(false);
    if (res.data.code == 200 && res.data.data) {
      setData(res.data.data);
    } else {
      alert('Không lấy được danh sách phương thức thanh toán!');
    }
  };

  return (
    <MethodPayView
      onRefresh={onRefresh}
      listMethod={data}
      isRefresh={isRefresh}
    />
  );
};

export default MethodPay;
