import React, {useState, useEffect} from 'react';
import {
  View,
  Text,
  StyleSheet,
  FlatList,
  Dimensions,
  TouchableOpacity,
  Alert,
  ScrollView,
  KeyboardAvoidingView,
  Platform,
  TouchableWithoutFeedback,
  Keyboard,
} from 'react-native';
import {connect} from 'react-redux';
import R from '../../assets/R';
import HeaderBack from '../../components/Header/HeaderBack';

import Item from './Item';
import {getFontXD, WIDTHXD, checkFormatArray} from '../../Config/Functions';
import TextField from '../../components/Input/TextField';
import PickerItem from '../../components/Picker/PickerItem';
import {getListBank, addMethodBank} from '../../apis/Functions/Widthdraw';
import {showLoading, hideLoading} from '../../actions/loadingAction';
import {useNavigation} from '@react-navigation/native';

const {width} = Dimensions.get('window');

const AddMethodPay = (props) => {
  const [data, setData] = useState([]);
  const navigate = useNavigation();

  const [bank_id, setBankID] = useState();
  const [branch_name, setBankName] = useState();
  const [account_name, setAccountName] = useState();
  const [account_no, setAccountNo] = useState();

  useEffect(() => {
    getData();
  }, []);

  const getData = async () => {
    const res = await getListBank({
      platform: Platform.OS,
    });
    if (res.data.code == 200 && res.data.data) {
      setData(res.data.data);
    } else {
      alert('Không lấy được danh sách ngân hàng!');
    }
  };

  const onLick = async () => {
    const titles = [
      'ngân hàng',
      'chi nhánh',
      'chủ tài khoản',
      'số tài khoản ngân hàng',
    ];
    const index = checkFormatArray([
      bank_id,
      branch_name,
      account_name,
      account_no,
    ]);
    if (index === true) {
      props.showLoading();
      const res = await addMethodBank({
        platform: Platform.OS,
        bank_id: bank_id.id,
        branch_name,
        account_name,
        account_no,
      });
      props.hideLoading();
      if (res.data.code == 200) {
        setTimeout(() => {
          Alert.alert('Thông báo!', res.data.message);
          navigate.goBack();
        }, 500);
      } else {
        setTimeout(() => {
          Alert.alert('Thông báo!', res.data.message);
        }, 500);
      }
    } else {
      Alert.alert('Vui lòng điền ' + titles[index]);
    }
  };

  return (
    <KeyboardAvoidingView
      behavior={Platform.Os === 'ios' ? 'padding' : 'height'}
      style={{flex: 1}}
      keyboardVerticalOffset={-50}>
      <TouchableWithoutFeedback onPress={Keyboard.dismiss}>
        <View style={{flex: 1}}>
          <HeaderBack title={'Thêm phương thức thanh toán'} />
          <View style={styles.container}>
            <View style={{flex: 1}}>
              <Text style={styles.txtTitle}>Chọn ngân hàng </Text>
              <PickerItem
                value={bank_id}
                data={data}
                onValueChange={(value, items) => {
                  setBankID(items);
                }}
              />
              <TextField
                onChangeText={(val) => setBankName(val)}
                title={'Chi nhánh'}
              />

              <TextField
                onChangeText={(val) => setAccountName(val)}
                title={'Tên chủ tài khoản'}
              />
              <TextField
                onChangeText={(val) => setAccountNo(val)}
                title={'Số tài khoản ngân hàng'}
                isNumber={true}
              />
            </View>
            <View style={{justifyContent: 'center', alignItems: 'center'}}>
              <TouchableOpacity onPress={onLick} style={styles.btn}>
                <Text style={styles.txtAdd}>Thêm</Text>
              </TouchableOpacity>
            </View>
          </View>
        </View>
      </TouchableWithoutFeedback>
    </KeyboardAvoidingView>
  );
};

const styles = StyleSheet.create({
  container: {
    paddingHorizontal: 10,
    paddingTop: 10,
    flex: 1,
  },

  btn: {
    width: 150,
    height: 40,
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: R.colors.main,
    borderRadius: 5,
    marginBottom: 10,
  },
  txtAdd: {
    color: R.colors.white,
    fontSize: getFontXD(46),
    textTransform: 'uppercase',
    fontWeight: 'bold',
  },
  txtTitle: {
    fontSize: getFontXD(42),
    color: R.colors.color777,
    marginBottom: 5,
  },
});

const mapStateToProps = (state) => {
  return {
    user: state.userReducer,
  };
};
export default connect(mapStateToProps, {
  showLoading,
  hideLoading,
})(AddMethodPay);
