import React, {useState} from 'react';
import {
  View,
  Text,
  TextInput,
  TouchableOpacity,
  StyleSheet,
  Touchable,
  TouchableOpacityBase,
  Dimensions,
  KeyboardAvoidingView,
  ScrollView,
  Platform,
  TouchableWithoutFeedback,
  Keyboard,
} from 'react-native';
import R from '../../../../assets/R';
import RadioForm, {
  RadioButton,
  RadioButtonInput,
  RadioButtonLabel,
} from 'react-native-simple-radio-button';
import PickerDate from '../../../../components/Picker/PickerDate';
import TextMulti from '../../../../components/Input/TextMulti';
import {connect} from 'react-redux';
import {showLoading, hideLoading} from '../../../../actions/loadingAction';
import {converStringToDate} from '../../../../Config/Functions';
var radio_props = [
  {label: 'Nam', value: 0},
  {label: 'Nữ', value: 1},
];
const {width} = Dimensions.get('window');

import TextField from '../../../../components/Input/TextField';
import PickerItem from '../../../../components/Picker/PickerItem';
import {
  getFontXD,
  HEIGHTXD,
  WIDTHXD,
  renderStatus,
} from '../../../../Config/Functions';
import Icon from 'react-native-vector-icons/Ionicons';

const GeneralInfor = (props) => {
  const [Select, setSelect] = useState('ABC');
  const [bank, setBank] = useState();
  const [account, setAccount] = useState();

  return (
    <KeyboardAvoidingView
      behavior={Platform.Os === 'ios' ? 'padding' : 'height'}
      style={{flex: 1}}
      keyboardVerticalOffset={-500}>
      <TouchableWithoutFeedback onPress={Keyboard.dismiss}>
        <ScrollView style={{flex: 1}} showsVerticalScrollIndicator={false}>
          <View style={styles.container}>
            <TextField
              value={props.user.fullname}
              editable={false}
              title={'Họ và tên'}
              onChangeText={(val) => console.log(val)}
            />
            <TextField
              title={'Điện thoại'}
              editable={false}
              value={props.user.phone}
              onChangeText={(val) => console.log(val)}
            />

            <TextField
              editable={false}
              title={'Email'}
              value={props.user.email}
              onChangeText={(val) => console.log(val)}
            />
            {/* 
      <TextInput
        style={styles.customTxt}
        onChangeText={(val) => console.log(val)}
        placeholder="0000"
      /> */}

            <Text style={styles.txtTitle}>Giới tính</Text>

            <RadioForm
              radio_props={radio_props}
              labelStyle={{fontSize: getFontXD(42)}}
              formHorizontal={true}
              style={styles.row}
              initial={0}
              onPress={(value) => {
                setAccount({value: value});
              }}
            />

            <View style={styles.status}>
              <Text style={styles.txtTitle}>Trạng thái</Text>
              {renderStatus(props.user.status)}
            </View>

            <PickerDate
              valueString={converStringToDate(props.user.birthday)}
              title={'Ngày sinh'}
              disabled={true}
            />

            <TextMulti
              onChangeText={(val) => consoele.log(val)}
              value={props.user.address}
              editable={false}
              title={'Địa chỉ'}
            />

            <View style={{height: 40}} />
            <View style={{justifyContent: 'center', alignItems: 'center'}}>
              {/* <TouchableOpacity
              onPress={() => console.log('Hello')}
              style={styles.btn}>
              <Text style={styles.txtBtn}>Cập nhật</Text>
            </TouchableOpacity> */}
            </View>
          </View>
        </ScrollView>
      </TouchableWithoutFeedback>
    </KeyboardAvoidingView>
  );
};

const styles = StyleSheet.create({
  container: {
    flex: 1,
    paddingHorizontal: 10,
    paddingVertical: 10,
  },
  customTxt: {
    height: HEIGHTXD(110),
    color: 'black',
    borderRadius: 7,
    borderWidth: 0.7,
    borderColor: '#DBDBDB',
    fontSize: getFontXD(42),
    paddingVertical: 5,
    paddingHorizontal: 10,
    backgroundColor: 'white',
    shadowColor: '#AFA9A9',
    shadowOffset: {
      width: 0,
      height: 1,
    },
    shadowOpacity: 0.25,
    shadowRadius: 1.84,
    elevation: 1,
    marginTop: 50,
    marginBottom: 20,
  },
  status: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    marginVertical: 10,
    alignItems: 'center',
  },
  footer: {
    justifyContent: 'center',
    alignItems: 'center',
    marginBottom: 30,
  },
  btn: {
    width: 180,
    height: HEIGHTXD(120),
    borderRadius: 10,
    backgroundColor: '#1C6AF6',
    justifyContent: 'center',
    alignItems: 'center',
  },
  txtBtn: {
    color: R.colors.white,
    fontSize: getFontXD(52),
    textTransform: 'uppercase',
  },
  customAdd: {
    borderWidth: 1,
    borderColor: '#929292',
    paddingHorizontal: 5,
    borderRadius: 5,
    marginRight: 10,
  },
  txtTitle: {
    fontSize: getFontXD(42),
    color: R.colors.color777,
    marginBottom: 5,

    paddingTop: 5,
  },
  row: {
    height: HEIGHTXD(109),
    width: '100%',
    justifyContent: 'space-between',
    marginVertical: 5,
    width: 250,
  },
});

const mapStateToProps = (state) => {
  return {
    user: state.userReducer,
  };
};
export default connect(mapStateToProps, {showLoading, hideLoading})(
  GeneralInfor,
);
