import React from 'react';
import {View, FlatList} from 'react-native';
import HeaderSearch from '../../../components/Header/HeaderBack';
import Item from './Item';

const data = [
  {
    id: '1',
    time: '20/02/2021',
    money: 5000000,
    content: 'Mua kim loại ở sàn CBOT',
  },
  {
    id: '2',
    time: '20/02/2021',
    money: 8000000,
    content:
      'Nhà đầu tư vẫn thu được lợi nhuận ngay cả khi thị trường đi xuống do có thể bán trước',
  },
];

const Payments = (props) => {
  return (
    <View>
      <HeaderSearch isWhite={false} title={'Các khoản thanh toán'} />

      <FlatList
        keyExtractor={(item) => item.id}
        data={data}
        renderItem={({item}) => <Item item={item} />}
      />
    </View>
  );
};

export default Payments;
