import React from 'react';
import {View, Text, StyleSheet, TouchableOpacity, Image} from 'react-native';
import {
  getFontXD,
  HEIGHTXD,
  WIDTHXD,
  toPriceVnd,
} from '../../../Config/Functions';
import R from '../../../assets/R';
import Block from '../../../components/Block';

const Item = (props) => {
  const {item} = props;
  return (
    <TouchableOpacity onPress={() => console.log('HEllo')}>
      <View style={styles.container}>
        <Block flex={1} row>
          <Block padding={[5, 10]} space={'between'} flex={1}>
            <View style={{justifyContent: 'center', flex: 1}}>
              <Text style={styles.txt1}>
                Tiền thưởng:{' '}
                <Text style={styles.money}>{toPriceVnd(item.money)}</Text> vnđ
              </Text>
              <Text numberOfLines={1} style={styles.txt2}>
                Nội dung: {item.content}
              </Text>
            </View>
            <Text style={styles.txt}>{item.time}</Text>
          </Block>
        </Block>
      </View>
    </TouchableOpacity>
  );
};

export default Item;

const styles = StyleSheet.create({
  container: {
    marginTop: 10,
    height: HEIGHTXD(250),
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 2,
    },
    shadowOpacity: 0.25,
    shadowRadius: 3.84,
    elevation: 5,
    marginHorizontal: 10,
    backgroundColor: R.colors.white,
    marginBottom: 10,
    borderRadius: HEIGHTXD(30),
  },

  wrapLeft: {
    width: WIDTHXD(16),
    borderTopLeftRadius: HEIGHTXD(30),
    borderBottomStartRadius: HEIGHTXD(30),
  },
  wrapDate: {
    justifyContent: 'center',
    paddingHorizontal: 10,
  },
  txtTitle: {
    fontSize: getFontXD(42),
    color: R.colors.black,
    fontWeight: 'bold',
  },
  txt: {
    fontSize: getFontXD(39),
    color: '#C4C4C4',
    fontStyle: 'italic',
  },
  rowBet: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    alignItems: 'center',
  },
  txt1: {
    fontSize: getFontXD(42),
    color: '#0B2031',
  },
  txt2: {
    fontSize: getFontXD(42),
    color: '#0B2031',
    marginVertical: 2,
  },
  imgIcon: {
    width: WIDTHXD(178),
    height: HEIGHTXD(178),
    resizeMode: 'contain',
  },
  money: {
    color: '#E3434F',
  },
});
