import React from 'react';
import {View, Text, StyleSheet, TouchableOpacity} from 'react-native';
import R from '../../assets/R';
import HeaderBack from '../../components/Header/HeaderBack';
import {getFontXD} from '../../Config/Functions';
import {useNavigation} from '@react-navigation/native';
import {
  LEGALPARTNER,
  LEGALCUSTOMER,
  LEGALBUSINESS,
} from '../../routers/ScreenNames';

const LegalDocument = (props) => {
  const navigate = useNavigation();
  return (
    <View style={{flex: 1}}>
      <HeaderBack title={'Giấy tờ pháp lý'} />
      <View style={styles.container}>
        <TouchableOpacity
          onPress={() => navigate.navigate(LEGALCUSTOMER)}
          style={styles.containerItem}>
          <Text style={styles.txtTitle}> Thoả thuận khách hàng</Text>
        </TouchableOpacity>
        <TouchableOpacity
          onPress={() => navigate.navigate(LEGALBUSINESS)}
          style={styles.containerItem}>
          <Text style={styles.txtTitle}> Thoả thuận kinh doanh chung</Text>
        </TouchableOpacity>
        <TouchableOpacity
          onPress={() => navigate.navigate(LEGALPARTNER)}
          style={styles.containerItem}>
          <Text style={styles.txtTitle}> Thoả thuận quan hệ đối tác</Text>
        </TouchableOpacity>
      </View>
    </View>
  );
};

export default LegalDocument;

const styles = StyleSheet.create({
  txtTitle: {
    fontSize: getFontXD(42),
    color: '#001C51',
    paddingVertical: 15,
  },
  containerItem: {
    borderBottomWidth: 0.7,
    borderBottomColor: R.colors.borderGray,
    paddingHorizontal: 20,
  },
  container: {
    flex: 1,

    paddingTop: 20,
  },
});
