import React from 'react';
import {View, Text, StyleSheet, TouchableOpacity} from 'react-native';
import R from '../../assets/R';
import HeaderBack from '../../components/Header/HeaderBack';
import {getFontXD} from '../../Config/Functions';
import {useNavigation} from '@react-navigation/native';

const Business = (props) => {
  const navigate = useNavigation();
  return (
    <View style={{flex: 1}}>
      <HeaderBack title={'Kinh doanh chung'} />
      <View style={styles.container}>
        <Text
          style={{
            fontSize: 18,
            fontWeight: 'bold',
            textAlign: 'center',
          }}>
          Tính năng đang được phát triển, vui lòng quay lại sau!
        </Text>
      </View>
    </View>
  );
};

export default Business;

const styles = StyleSheet.create({
  txtTitle: {
    fontSize: getFontXD(42),
    color: '#001C51',
    paddingVertical: 15,
  },
  containerItem: {
    borderBottomWidth: 0.7,
    borderBottomColor: R.colors.borderGray,
    paddingHorizontal: 20,
  },
  container: {
    flex: 1,
    justifyContent: 'center',
    alignItems: 'center',
    paddingTop: 20,
  },
});
