import React from 'react';
import {
  View,
  Text,
  ImageBackground,
  StyleSheet,
  ScrollView,
} from 'react-native';
import HeaderHome from '../../components/Header/HeaderHome';
import Footer from './Footer';
import {HEIGHT, HEIGHTXD, toPriceVnd, getFontXD} from '../../Config/Functions';
import R from '../../assets/R';
const HomeView = (props) => {
  const {total_deposit, total_withdraw} = props.data;
  return (
    <ImageBackground
      source={R.images.bgHome}
      resizeMode={'stretch'}
      style={{width: '100%', height: '100%'}}>
      <ScrollView showsVerticalScrollIndicator={false}>
        <HeaderHome />
        <View style={styles.containerMenu}>
          <View style={styles.row}>
            <View style={styles.row}>
              <View style={styles.itemMenu}>
                <Text style={styles.txtTitle}>Nạp tiền</Text>
                <Text style={styles.txtMoney}>
                  {' '}
                  {total_deposit == 0 ? 0 : toPriceVnd(total_deposit)} Đ{' '}
                </Text>
              </View>
              <View
                style={{width: 0.5, backgroundColor: R.colors.borderGray}}
              />
              <View style={styles.itemMenu}>
                <Text style={styles.txtTitle}>Rút tiền</Text>
                <Text style={styles.txtMoney}>
                  {' '}
                  {total_withdraw == 0 ? 0 : toPriceVnd(total_withdraw)} Đ{' '}
                </Text>
              </View>
            </View>
          </View>
          <View style={{height: 0.5, backgroundColor: R.colors.borderGray}} />
          <View style={styles.row}>
            <View style={styles.itemMenu}>
              <Text style={styles.txtTitle}>Hoa hồng</Text>
              <Text style={styles.txtMoney1}>+ 0 Đ </Text>
            </View>
            <View style={{width: 0.5, backgroundColor: R.colors.borderGray}} />
            <View style={styles.itemMenu}>
              <Text style={styles.txtTitle}>Lợi nhuận</Text>
              <Text style={styles.txtMoney1}>0 Đ</Text>
            </View>
          </View>
        </View>

        <Footer />
      </ScrollView>
    </ImageBackground>
  );
};

export default HomeView;
const styles = StyleSheet.create({
  body: {
    flex: 1,
    backgroundColor: '#DFE7F5',

    marginTop: 60,
    borderTopLeftRadius: 60,
  },
  containerBody: {
    marginTop: -50,
  },
  containerMenu: {
    height: 160,
    backgroundColor: 'white',
    marginTop: 20,
    marginBottom: 10,
    marginHorizontal: 20,
    borderRadius: 10,
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 1,
    },
    shadowOpacity: 0.25,
    shadowRadius: 2.84,
    elevation: 3,
  },
  row: {
    flexDirection: 'row',
    flex: 1,
  },
  itemMenu: {
    flex: 1,
    justifyContent: 'center',
    alignItems: 'center',
  },
  txtTitle: {
    fontSize: getFontXD(36),
    color: '#00359C',
    textTransform: 'uppercase',
    fontWeight: 'bold',
  },
  txtMoney: {
    fontSize: getFontXD(42),
    color: R.colors.black,
    marginTop: 5,
  },
  txtMoney1: {
    fontSize: getFontXD(42),
    color: '#2fbd04',
    marginTop: 5,
  },
});
