import React, {useEffect, useState} from 'react';
import {View, Alert} from 'react-native';
import {connect} from 'react-redux';
import {getTransaction} from '../../apis/Functions/users';

import HomeView from './HomeView';

const Home = (props) => {
  const [data, setData] = useState({total_deposit: 0, total_withdraw: 0});
  useEffect(() => {
    getData();
  }, []);
  console.log();
  props.user;
  const getData = async () => {
    const res = await getTransaction({});
    if (res.data.code == 200 && res.data.data) {
      setData(res.data.data);
    } else {
      Alert.alert('Thông báo!', 'Không lấy được thông tin!');
    }
  };

  return <HomeView data={data} />;
};

const mapStateToProps = (state) => {
  return {
    user: state.userReducer,
  };
};
export default connect(mapStateToProps, {})(Home);
