import React, {useState} from 'react';
import {
  View,
  Text,
  StyleSheet,
  Image,
  TouchableOpacity,
  Alert,
} from 'react-native';
import InputIcon from '../../components/Input/InputIcon';
import {getFontXD, HEIGHTXD, WIDTHXD} from '../../Config/Functions';
import R from '../../assets/R';
import {checkFormatArray} from '../../Config/Functions';
import {showLoading, hideLoading} from '../../actions/loadingAction';
import {connect} from 'react-redux';
import {registorApi} from '../../apis/Functions/users';

const Registor = (props) => {
  const {navigation} = props;

  const [email, setEmail] = useState('');
  const [password, setPassword] = useState('');
  const [password_confirmation, setPasswordConfirm] = useState('');
  const [sponsor_id, setSponsor_id] = useState('');

  const registorClick = async () => {
    const titles = ['email', 'mật khẩu', 'xác nhận mật khẩu'];
    const index = checkFormatArray([email, password, password_confirmation]);

    if (index === true) {
      let res;
      props.showLoading();
      if (sponsor_id) {
        res = await registorApi({
          email,
          password,
          platform: Platform.OS,
          password_confirmation,
          sponsor_id,
        });
      } else {
        res = await registorApi({
          email,
          password,
          platform: Platform.OS,
          password_confirmation,
        });
      }

      props.hideLoading();

      if (res.data.code == 200 && res.data.data) {
        setTimeout(() => {
          Alert.alert('Thông báo', 'Đăng ký tài khoản thành công!');
          navigation.navigate('LOGIN');
        }, 500);
      } else {
        setTimeout(() => {
          Alert.alert('Thông báo!', res.data.message);
        }, 500);
      }
    } else {
      Alert.alert('Thông báo!', 'Vui lòng điền ' + titles[index]);
    }
  };

  return (
    <View
      style={{
        flex: 1,
        paddingHorizontal: 20,
        paddingTop: 20,
        backgroundColor: 'white',
      }}>
      <InputIcon
        icon={R.images.iconEmail}
        title={'Email đăng ký'}
        placeholder={'Nhập email'}
        onChangeText={(val) => setEmail(val)}
      />

      <InputIcon
        icon={R.images.iconLock}
        title={'Mật khẩu'}
        placeholder={'Nhập mật khẩu'}
        onChangeText={(val) => setPassword(val)}
        isPassWord={true}
      />
      <InputIcon
        icon={R.images.iconLock}
        title={'Nhập lại mật khẩu'}
        placeholder={'Nhập mật khẩu'}
        onChangeText={(val) => setPasswordConfirm(val)}
        isPassWord={true}
      />
      <InputIcon
        icon={R.images.iconIntroduct}
        title={'Mã giới thiệu'}
        placeholder={'Nhập mã giới thiệu nếu có'}
        onChangeText={(val) => setSponsor_id(val)}
        isPassWord={true}
      />

      <View
        style={{
          marginTop: 30,
          alignItems: 'center',
        }}>
        <TouchableOpacity onPress={registorClick} style={styles.wrapLogin}>
          <Text style={styles.txtLogin}>Đăng ký</Text>
          <Image source={R.images.iconRight1} style={styles.imgIcon} />
        </TouchableOpacity>

        <View style={styles.row}>
          <Text style={styles.txtTitle}>Bạn đã có tài khoản?</Text>
          <TouchableOpacity
            onPress={() => {
              navigation.navigate('LOGIN');
            }}>
            <Text style={styles.txtRegistor}>Đăng nhập</Text>
          </TouchableOpacity>
        </View>
      </View>
    </View>
  );
};

const styles = StyleSheet.create({
  forgotView: {
    marginVertical: 20,
    alignItems: 'flex-end',
  },
  txtTitle: {
    fontSize: getFontXD(42),
    color: '#929292',
  },
  txtLogin: {
    fontSize: getFontXD(48),
    color: 'white',
    fontWeight: '700',
  },
  wrapLogin: {
    width: WIDTHXD(512),
    height: HEIGHTXD(150),
    backgroundColor: '#1C6AF6',
    borderRadius: 30,
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
  },
  imgIcon: {
    width: WIDTHXD(72),
    height: HEIGHTXD(72),
    marginLeft: 5,
  },
  row: {
    flexDirection: 'row',
    marginTop: 30,
  },
  txtRegistor: {
    fontSize: getFontXD(42),
    color: '#1473E6',
  },
});

const mapStateToProps = (state) => {
  return {};
};
export default connect(mapStateToProps, {
  showLoading,
  hideLoading,
})(Registor);
