import React, {useState} from 'react';
import {
  View,
  Text,
  TextInput,
  StyleSheet,
  TouchableOpacity,
  Alert,
  Platform,
} from 'react-native';
import HeaderBack from '../../components/Header/HeaderBack';
import {forgotPasswordApi} from '../../apis/Functions/users';
import {useNavigation} from '@react-navigation/native';

import {getFontXD, HEIGHTXD, WIDTHXD} from '../../Config/Functions';
import R from '../../assets/R';
import {AUTHEN} from '../../routers/ScreenNames';

import {showLoading, hideLoading} from '../../actions/loadingAction';
import {connect} from 'react-redux';

const NewPassword = (props) => {
  const [password, setPassword] = useState('');
  const [cfPassword, setcfPassword] = useState('');

  const navigate = useNavigation();
  const {email, otp} = props.route.params;

  const changePass = async () => {
    if (!password || !cfPassword) {
      Alert.alert('Vui lòng điền đầy đủ thông tin!');
    } else {
      props.showLoading();
      const res = await forgotPasswordApi({
        receiver_name: email,
        otp,
        password,
        password_confirmation: cfPassword,
        platform: Platform.OS,
      });
      props.hideLoading();

      if (res.data.code == 200) {
        await setTimeout(() => {
          Alert.alert('Thông báo!', 'Đổi mật khẩu thành công');
          navigate.reset({
            index: 1,
            routes: [{name: AUTHEN}],
          });
        }, 500);
      } else {
        setTimeout(() => {
          console.log('response', res.data);
          Alert.alert('Thông báo!', res.data.message);
        }, 500);
      }
    }
  };

  return (
    <View style={{flex: 1}}>
      <HeaderBack title={'Thay đổi mật khẩu mới'} />

      <View style={styles.container}>
        <View style={styles.wrap}>
          <View style={styles.containerCode1}>
            <Text style={styles.txtTitle}>Vui lòng nhập mật khẩu mới</Text>
            <TextInput
              style={styles.txtInput}
              placeholder="Nhập mật khẩu mới"
              placeholderTextColor={R.colors.placeHolder}
              autoCapitalize="none"
              value={password}
              secureTextEntry={true}
              onChangeText={(val) => setPassword(val)}
            />
          </View>
          <View style={styles.containerCode2}>
            <Text style={styles.txtTitle}>Nhập lại mật khẩu</Text>
            <TextInput
              style={styles.txtInput}
              autoCapitalize="none"
              placeholder="Xác nhận lại mật khẩu mới"
              value={cfPassword}
              secureTextEntry={true}
              placeholderTextColor={R.colors.placeHolder}
              onChangeText={(val) => setcfPassword(val)}
            />
          </View>
        </View>
      </View>

      <View style={styles.footer}>
        <TouchableOpacity onPress={changePass} style={styles.btn}>
          <Text style={styles.txtBtn}>Cập nhật</Text>
        </TouchableOpacity>
      </View>
    </View>
  );
};

const styles = StyleSheet.create({
  container: {
    flex: 1,
    justifyContent: 'center',
    alignItems: 'center',
    paddingVertical: 10,
    paddingHorizontal: 10,
  },
  footer: {
    height: 200,
    justifyContent: 'center',
    alignItems: 'center',
  },
  wrap: {
    flex: 1,
    paddingTop: 10,
    alignItems: 'center',
    width: '100%',
  },
  containerCode1: {
    height: 50,
    width: '100%',
    marginTop: 10,
  },
  containerCode2: {
    height: 50,
    width: '100%',
    marginTop: 30,
  },
  codeFieldRoot: {
    marginTop: 20,
  },
  txtTitle: {
    fontSize: getFontXD(48),
    color: '#141414',
    marginBottom: 12,
  },
  txtInput: {
    height: HEIGHTXD(99),

    borderBottomWidth: 2,
    borderBottomColor: '#DBEBFF',
    fontSize: getFontXD(46),

    paddingVertical: 2,

    color: 'black',
  },
  btn: {
    width: WIDTHXD(550),
    height: HEIGHTXD(120),
    borderRadius: 22,
    backgroundColor: '#1C6AF6',
    justifyContent: 'center',
    alignItems: 'center',
  },
  txtBtn: {
    color: R.colors.white,
    fontSize: getFontXD(52),
    textTransform: 'uppercase',
  },
  txtSend: {
    marginTop: 30,
    fontSize: getFontXD(42),
    color: '#1C6AF6',
  },
});

const mapStateToProps = (state) => {
  return {};
};

export default connect(mapStateToProps, {showLoading, hideLoading})(
  NewPassword,
);
