import React, {useState} from 'react';
import {
  View,
  Text,
  StyleSheet,
  Dimensions,
  TouchableOpacity,
  Alert,
} from 'react-native';
import R from '../../../assets/R';
import HeaderBack from '../../../components/Header/HeaderBack';
import TextField from '../../../components/Input/TextField';
import TextMulti from '../../../components/Input/TextMulti';
import TextDisable from '../../../components/Input/TextDisable';
import {useNavigation} from '@react-navigation/native';
import {
  getFontXD,
  toPriceVnd,
  checkFormatArray,
} from '../../../Config/Functions';
import {connect} from 'react-redux';
import {showLoading, hideLoading} from '../../../actions/loadingAction';
import {walletDeposit} from '../../../apis/Functions/Deposit';

const {width} = Dimensions.get('window');

const WalletDeposit = (props) => {
  const [amount, setAmount] = useState();
  const [notes, setNotes] = useState();
  const navigate = useNavigation();

  const onClick = async () => {
    const titles = ['số tiền', 'ghi chú'];

    const index = checkFormatArray([amount, notes]);
    if (index === true) {
      props.showLoading();
      const res = await walletDeposit({
        amount,
        platform: Platform.OS,
        notes,
        fee: 0,
      });
      props.hideLoading();

      if (res.data.code == 200) {
        setTimeout(() => {
          Alert.alert('Thông báo!', res.data.message);
          navigate.goBack();
        }, 500);
      } else {
        setTimeout(() => {
          Alert.alert('Thông báo!', res.data.message);
        }, 500);
      }
    } else {
      Alert.alert('Vui lòng điền ' + titles[index]);
    }
  };
  return (
    <View style={{flex: 1}}>
      <HeaderBack title={'Nạp tiền đầu tư'} />
      <View style={styles.container}>
        <View style={styles.wrapTop}>
          <View style={styles.itemTop}>
            <Text style={styles.txtTitle}>Ví</Text>
            <Text style={styles.txtMoney}>
              {' '}
              {props.user.current_money != 0
                ? toPriceVnd(props.user.current_money)
                : 0}{' '}
            </Text>
          </View>
          <View style={{width: 1, backgroundColor: '#DBDBDB'}} />
          <View style={styles.itemTop}>
            <Text style={styles.txtTitle}>CQG</Text>
            <Text style={styles.txtMoney}>
              {' '}
              {props.user.current_cqg_money != 0
                ? toPriceVnd(props.user.current_cqg_money)
                : 0}{' '}
              đ
            </Text>
          </View>
        </View>
        <View style={styles.wrapBody}>
          {/* <TextDisable value={'10010101'} title={'Số tài khoản CQG'} /> */}
          <TextField
            onChangeText={(val) => setAmount(val)}
            title={'Số tiền'}
            isNumber={true}
          />
          <TextMulti onChangeText={(val) => setNotes(val)} title={'Ghi chú'} />
        </View>
      </View>
      <TouchableOpacity onPress={onClick} style={styles.btnSend}>
        <Text style={styles.txtSend}>Nạp tiền</Text>
      </TouchableOpacity>
    </View>
  );
};

const styles = StyleSheet.create({
  container: {
    backgroundColor: R.colors.white,
    marginVertical: 10,
    shadowColor: '#AFA9A9',
    shadowOffset: {
      width: 0,
      height: 1,
    },
    shadowOpacity: 0.25,
    shadowRadius: 1.84,
    elevation: 1,
  },
  wrapTop: {
    flexDirection: 'row',
    borderBottomWidth: 1,
    borderBottomColor: '#DBDBDB',
  },
  itemTop: {
    flex: 1,
    justifyContent: 'center',
    alignItems: 'center',
    paddingVertical: 20,
  },
  wrapBody: {
    paddingHorizontal: 10,
    paddingVertical: 20,
  },
  txtMoney: {
    color: '#1C6AF6',
    fontSize: getFontXD(52),
  },
  txtTitle: {
    color: R.colors.black,
    fontSize: getFontXD(42),
  },
  txtSend: {
    fontSize: getFontXD(42),
    color: R.colors.white,
    fontWeight: 'bold',
  },
  btnSend: {
    position: 'absolute',
    bottom: 30,
    right: width / 2 - 70,
    width: 140,
    height: 40,
    backgroundColor: R.colors.main,
    borderRadius: 10,
    justifyContent: 'center',
    alignItems: 'center',
  },
});

const mapStateToProps = (state) => {
  return {
    user: state.userReducer,
  };
};
export default connect(mapStateToProps, {showLoading, hideLoading})(
  WalletDeposit,
);
