import React from 'react';
import {View, Text, StyleSheet, TouchableOpacity} from 'react-native';
import HeaderBack from '../../../components/Header/HeaderBack';
import Success from './Tab/Success';
import Watting from './Tab/Watting';
import {getFontXD} from '../../../Config/Functions';
import {WALLETDEPOSIT, WALLETWITHDRAW} from '../../../routers/ScreenNames';

import {createMaterialTopTabNavigator} from '@react-navigation/material-top-tabs';
import R from '../../../assets/R';
const Tab = createMaterialTopTabNavigator();
import {useNavigation} from '@react-navigation/native';
const Wallet = (props) => {
  const navigate = useNavigation();
  return (
    <View style={{flex: 1}}>
      <HeaderBack isWhite={true} title={'Ví tiền'} />

      <View style={{flex: 1, backgroundColor: 'red'}}>
        <Tab.Navigator
          initialRouteName="GeneralInfor"
          tabBarOptions={{
            inactiveTintColor: '#929292',
            activeTintColor: '#1473E6',
            labelStyle: {fontSize: getFontXD(36), fontWeight: '700'},
            style: {backgroundColor: 'white'},
          }}>
          <Tab.Screen
            name="Tab1"
            component={Watting}
            options={{tabBarLabel: 'Đang chờ'}}
          />
          <Tab.Screen
            name="Tab2"
            component={Success}
            options={{tabBarLabel: 'Thành công'}}
          />
        </Tab.Navigator>
      </View>

      <TouchableOpacity
        onPress={() => navigate.navigate(WALLETDEPOSIT)}
        style={styles.btnLeft}>
        <Text style={styles.txtTitle}>Nạp tiền</Text>
      </TouchableOpacity>
      <TouchableOpacity
        onPress={() => navigate.navigate(WALLETWITHDRAW)}
        style={styles.btnRight}>
        <Text style={styles.txtTitle}>Rút tiền</Text>
      </TouchableOpacity>
    </View>
  );
};

const styles = StyleSheet.create({
  footer: {
    height: 50,
    width: '100%',
    flexDirection: 'row',
    justifyContent: 'space-around',
  },
  btnRight: {
    width: 140,
    height: 40,
    backgroundColor: R.colors.main,
    borderRadius: 10,
    justifyContent: 'center',
    alignItems: 'center',
    position: 'absolute',
    bottom: 10,
    right: 30,
    shadowColor: '#AFA9A9',
    shadowOffset: {
      width: 0,
      height: 1,
    },
    shadowOpacity: 0.25,
    shadowRadius: 1.84,
    elevation: 1,
  },
  btnLeft: {
    width: 140,
    height: 40,
    backgroundColor: R.colors.main,
    borderRadius: 10,
    justifyContent: 'center',
    alignItems: 'center',
    position: 'absolute',
    bottom: 10,
    left: 30,
    shadowColor: '#AFA9A9',
    shadowOffset: {
      width: 0,
      height: 1,
    },
    shadowOpacity: 0.25,
    shadowRadius: 1.84,
    elevation: 1,
  },
  txtTitle: {
    fontSize: getFontXD(42),
    color: R.colors.white,
    fontWeight: 'bold',
  },
});

export default Wallet;
