import React, {useState} from 'react';
import {
  View,
  Text,
  FlatList,
  TouchableOpacity,
  StyleSheet,
  ScrollView,
} from 'react-native';
import HeaderBack from '../../../components/Header/HeaderBack';
import Item from './Item';
import {getFontXD} from '../../../Config/Functions';

const Fillters = [
  {
    id: '1',
    name: 'Tất cả',
    value: 'ALL',
  },
  {
    id: '2',
    name: 'Nạp tiền',
    value: 'DEPOSIT',
  },
  {
    id: '3',
    name: 'Rút tiền',
    value: 'WITHDRAW',
  },
  {
    id: '4',
    name: 'Chuyển khoản',
    value: 'TRANSFER',
  },
];

const HistoryView = (props) => {
  const {isRefresh, onRefresh, onLoadMore, data, selected, setSelected} = props;
  return (
    <View style={{flex: 1}}>
      <HeaderBack isWhite={true} title={'LỊCH SỬ'} />
      <View style={{flex: 1}}>
        <View style={styles.headerContainer}>
          <ScrollView horizontal showsHorizontalScrollIndicator={false}>
            {Fillters.map((e) => (
              <TouchableOpacity
                key={e.value}
                onPress={() => setSelected(e.value)}
                style={[
                  styles.itemFillter,
                  selected == e.value ? {borderColor: '#1473E6'} : null,
                ]}>
                <Text
                  style={[
                    styles.txtFillter,
                    selected == e.value ? {color: '#1473E6'} : {},
                  ]}>
                  {e.name}
                </Text>
              </TouchableOpacity>
            ))}
          </ScrollView>
        </View>

        {data.length == 0 ? (
          <View
            style={{justifyContent: 'center', alignItems: 'center', flex: 1}}>
            <Text
              style={{
                fontSize: getFontXD(46),
                fontWeight: 'bold',
              }}>
              Không có giao dịch nào!
            </Text>
          </View>
        ) : (
          <FlatList
            style={{flex: 1}}
            refreshing={isRefresh}
            onRefresh={onRefresh}
            onEndReachedThreshold={0.01}
            onEndReached={(info) => {
              onLoadMore();
            }}
            keyExtractor={(item) => item.id + 'a'}
            data={data}
            renderItem={({item}) => <Item item={item} />}
          />
        )}
      </View>
    </View>
  );
};

const styles = StyleSheet.create({
  headerContainer: {
    paddingVertical: 10,
    backgroundColor: 'white',
    flexDirection: 'row',
    justifyContent: 'space-around',
    alignItems: 'center',
    paddingHorizontal: 10,
  },
  itemFillter: {
    borderRadius: 10,
    paddingVertical: 5,
    paddingHorizontal: 10,
    borderWidth: 1,
    borderColor: '#929292',
    minWidth: 70,
    marginRight: 10,
  },
  txtFillter: {
    fontSize: getFontXD(36),
    color: '#929292',
  },
});

export default HistoryView;
