import React, {useState} from 'react';
import {
  View,
  Text,
  TouchableOpacity,
  Image,
  StyleSheet,
  KeyboardAvoidingView,
  ScrollView,
  Platform,
  Dimensions,
  Alert,
  TouchableWithoutFeedback,
  Keyboard,
} from 'react-native';
import TextField from '../../../components/Input/TextField';
import TextMulti from '../../../components/Input/TextMulti';
import {checkFormatArray, getFontXD} from '../../../Config/Functions';
import PickerDate from '../../../components/Picker/PickerDate';
import R from '../../../assets/R';
import Button from '../../../components/Button';
import PickerItem from '../../../components/Picker/PickerItem';
import {verifyAccountApi} from '../../../apis/Functions/users';
import {connect} from 'react-redux';
import {showLoading, hideLoading} from '../../../actions/loadingAction';
import {useNavigation} from '@react-navigation/native';

const {width} = Dimensions.get('window');
const dataType = [
  {
    value: '0',
    name: 'Tài khoản ngân hàng',
  },
  {
    value: '1',
    name: 'Tài khoản thẻ',
  },
];

const BankInfor = (props) => {
  const [acc_type, setAccType] = useState();
  const [bank_no, setBackNo] = useState('');
  const [account_no, setAccountNo] = useState('');

  console.log(props.route.params.body);

  const createFormData = (identity_after, identity_before, sign_img, body) => {
    const data = new FormData();

    data.append('identity_after', {
      name: 'identity_after.jpg',
      type: 'image/jpg',
      uri:
        Platform.OS === 'android'
          ? identity_after
          : identity_after.replace('file://', ''),
    });

    data.append('identity_before', {
      name: 'identity_before.jpg',
      type: 'image/jpg',
      uri:
        Platform.OS === 'android'
          ? identity_before
          : identity_before.replace('file://', ''),
    });

    data.append('sign_image', {
      name: 'sign_img.jpg',
      type: 'image/jpg',
      uri:
        Platform.OS === 'android' ? sign_img : sign_img.replace('file://', ''),
    });

    Object.keys(body).forEach((key) => {
      data.append(key, body[key]);
    });
    return data;
  };

  const onPress = async () => {
    const titles = ['loại thẻ', 'mã ngân hàng', 'số thẻ/tài khoản'];
    const index = checkFormatArray([acc_type, bank_no, account_no]);
    console.log('Data', props.route.params.body);

    if (index === true) {
      const data = createFormData(
        props.route.params.img.urlBack,
        props.route.params.img.urlFont,
        props.route.params.img.urlSign,
        {
          uid: props.user.uid,
          acc_type: 0,
          bank_no,
          account_no,
          ...props.route.params.body,
        },
      );
      props.showLoading();
      const res = await verifyAccountApi(data);
      props.hideLoading();

      if (res.data.code == 200) {
        setTimeout(() => {
          Alert.alert('Thông báo!', res.data.message);
        }, 500);
        setBackNo('');
        setAccountNo('');
        setAccType('');
      } else {
        setTimeout(() => {
          Alert.alert('Thông báo!', res.data.message);
        }, 500);
      }
    } else {
      Alert.alert('Vui lòng điền ' + titles[index]);
    }
  };

  return (
    <KeyboardAvoidingView
      behavior={Platform.Os === 'ios' ? 'padding' : 'height'}
      style={{flex: 1}}
      keyboardVerticalOffset={-50}>
      <TouchableWithoutFeedback onPress={Keyboard.dismiss}>
        <ScrollView showsVerticalScrollIndicator={false}>
          <View
            style={{
              flex: 1,
              paddingHorizontal: 10,
              paddingTop: 10,
            }}>
            <Text
              style={{
                fontSize: getFontXD(42),
                color: R.colors.color777,
              }}>
              Loại thẻ
            </Text>
            <PickerItem
              width={width - 20}
              data={dataType}
              onValueChange={(value, items) => {
                setAccType(items);
              }}
            />
            <TextField
              isNumber={true}
              title={'Mã ngân hàng'}
              onChangeText={(val) => setBackNo(val)}
            />
            <TextField
              title={'Số thẻ/tài khoản'}
              isNumber={true}
              onChangeText={(val) => setAccountNo(val)}
            />

            <View style={styles.btnSend}>
              <Button title={'Xác minh'} onClick={onPress} />
            </View>
          </View>
        </ScrollView>
      </TouchableWithoutFeedback>
    </KeyboardAvoidingView>
  );
};

const styles = StyleSheet.create({
  btnSend: {
    width: '100%',
    marginTop: 50,
  },
});

const mapStateToProps = (state) => {
  return {
    user: state.userReducer,
  };
};
export default connect(mapStateToProps, {showLoading, hideLoading})(BankInfor);
