import React, {useState} from 'react';
import {
  View,
  Text,
  KeyboardAvoidingView,
  ScrollView,
  Platform,
} from 'react-native';
import HeaderBack from '../../components/Header/HeaderBack';
import BankInfor from './Tab/BankInfor';
import GeneralInfor from './Tab/GeneralInfor';
import Profile from './Tab/Profile';
import GeneralView from './TabView/GeneralView';
import ProfileView from './TabView/ProfileView';
import {createMaterialTopTabNavigator} from '@react-navigation/material-top-tabs';
import {getFontXD} from '../../Config/Functions';
const Tab = createMaterialTopTabNavigator();
import {connect} from 'react-redux';

const AccountVerificationView = (props) => {
  return (
    <View style={{flex: 1}}>
      <HeaderBack isWhite={true} title={'Xác minh tài khoản'} />
      <Tab.Navigator
        initialRouteName="GeneralInfor"
        tabBarOptions={{
          inactiveTintColor: '#929292',
          activeTintColor: '#1473E6',
          labelStyle: {fontSize: getFontXD(36)},
          style: {backgroundColor: 'white'},
        }}>
        <Tab.Screen
          name="GeneralInfor"
          component={props.user.status == 1 ? GeneralInfor : GeneralView}
          options={{tabBarLabel: 'Thông tin chung'}}
        />
        <Tab.Screen
          name="Profile"
          component={props.user.status == 1 ? Profile : ProfileView}
          options={{tabBarLabel: 'Hồ sơ'}}
        />
      </Tab.Navigator>
    </View>
  );
};

const mapStateToProps = (state) => {
  return {
    user: state.userReducer,
  };
};
export default connect(mapStateToProps, {})(AccountVerificationView);
